/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration.jei;

import chargedcharms.ChargedCharms;
import chargedcharms.client.integration.CharmChargingRecipeMaker;
import chargedcharms.client.integration.jei.Recipes;
import chargedcharms.common.crafting.recipe.AbsorptionChargeRecipe;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.Internal;
import net.minecraft.class_10289;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import technology.roughness.whitenoise.platform.Services;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public class_2960 getPluginUid() {
        return ResourceLocationHelper.prefix("jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        class_10289 clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.method_64695().isEmpty()) {
            ChargedCharms.LOGGER.error("JEI Recipe Registration failed: No synced recipes");
            return;
        }
        Recipes recipes = new Recipes(clientSyncedRecipes);
        List<class_8786<class_3955>> allCraftingRecipes = recipes.getCraftingRecipes();
        List<class_8786<class_3955>> charmChargingRecipes = JEIPlugin.addChargingRecipes(allCraftingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, charmChargingRecipes);
        if (!Services.PLATFORM.isModLoaded("biomemakeover") || ConfigHandler.Common.disableEnchTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.enchantedTotemCharm)));
        }
        if (ConfigHandler.Common.disableRegenCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.regenerationCharm)));
        }
        if (ConfigHandler.Common.disableAbsorptionCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.absorptionCharm)));
        }
        if (ConfigHandler.Common.disableGlowupCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.glowupCharm)));
        }
        if (ConfigHandler.Common.disableTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.totemCharm)));
        }
        if (ConfigHandler.Common.disableSpeedCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.speedCharm)));
        }
        if (ConfigHandler.Common.disableWaterBreathingCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new class_1799((class_1935)ChargedCharmsItems.waterBreathingCharm)));
        }
    }

    private static List<class_8786<class_3955>> addChargingRecipes(List<class_8786<class_3955>> allCraftingRecipes) {
        IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>> replacers = new IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>>();
        ArrayList recipes = new ArrayList();
        CharmChargingRecipeMaker.createRecipes("jei").forEach(pair -> recipes.add((class_8786)pair.getSecond()));
        replacers.put(AbsorptionChargeRecipe.class, () -> recipes);
        return allCraftingRecipes.stream().map(class_8786::comp_1933).map(class_3955::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                ChargedCharms.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new class_8786[0]);
            }
        }).toList();
    }
}

