/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec CLIENT_SPEC;
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    public static final Map<String, Boolean> conditionsMap;
    private static final Client CLIENT;
    private static final Common COMMON;
    private static boolean loaded;

    public static void init() {
        conditionsMap.clear();
        conditionsMap.put("disableRegenCharm", Common.disableRegenCharm());
        conditionsMap.put("disableAbsorptionCharm", Common.disableAbsorptionCharm());
        conditionsMap.put("disableGlowupCharm", Common.disableGlowupCharm());
        conditionsMap.put("disableTotemCharm", Common.disableTotemCharm());
        conditionsMap.put("disableEnchTotemCharm", Common.disableEnchTotemCharm());
        conditionsMap.put("disableSpeedCharm", Common.disableSpeedCharm());
        conditionsMap.put("disableWaterBreathingCharm", Common.disableWaterBreathingCharm());
        loaded = true;
    }

    static {
        conditionsMap = new HashMap<String, Boolean>();
        loaded = false;
        Pair specPairClient = new WhiteNoiseConfigSpec.Builder().configure(Client::new);
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        CLIENT_SPEC = (WhiteNoiseConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue disableRegenCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableAbsorptionCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableGlowupCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableTotemCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableEnchTotemCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableSpeedCharm;
        private final WhiteNoiseConfigSpec.BooleanValue disableWaterBreathingCharm;
        private final WhiteNoiseConfigSpec.IntValue absorptionCooldown;
        private final WhiteNoiseConfigSpec.IntValue absorptionDuration;
        private final WhiteNoiseConfigSpec.IntValue absorptionAmplifier;
        private final WhiteNoiseConfigSpec.IntValue absorptionCharges;
        private final WhiteNoiseConfigSpec.DoubleValue regenPercentage;
        private final WhiteNoiseConfigSpec.IntValue regenDuration;
        private final WhiteNoiseConfigSpec.IntValue regenAmplifier;
        private final WhiteNoiseConfigSpec.IntValue regenCharges;
        private final WhiteNoiseConfigSpec.IntValue glowUpDuration;
        private final WhiteNoiseConfigSpec.IntValue glowUpCharges;
        private final WhiteNoiseConfigSpec.IntValue speedDuration;
        private final WhiteNoiseConfigSpec.IntValue speedCooldown;
        private final WhiteNoiseConfigSpec.IntValue speedCharges;
        private final WhiteNoiseConfigSpec.IntValue totemCharges;
        private final WhiteNoiseConfigSpec.IntValue airRemaining;
        private final WhiteNoiseConfigSpec.IntValue waterBreathingCharges;

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("charms");
            this.disableRegenCharm = builder.comment("Disable Charged Regeneration Charm").define("disableRegenCharm", false);
            this.disableAbsorptionCharm = builder.comment("Disable Charged Absorption Charm").define("disableAbsorptionCharm", false);
            this.disableGlowupCharm = builder.comment("Disable Charged Glow Up Charm").define("disableGlowupCharm", false);
            this.disableTotemCharm = builder.comment("Disable Charged Totem Charm").define("disableTotemCharm", false);
            this.disableEnchTotemCharm = builder.comment("Disable Charged Enchanted Totem Charm").define("disableEnchTotemCharm", false);
            this.disableSpeedCharm = builder.comment("Disable Charged Speed Charm").define("disableSpeedCharm", false);
            this.disableWaterBreathingCharm = builder.comment("Disable Charged Water Breathing Charm").define("disableWaterBreathingCharm", false);
            builder.pop();
            builder.push("tweaks");
            this.absorptionCooldown = builder.comment("Cooldown in seconds for the Charged Absorption Charm.").defineInRange("absorptionCooldown", 20, 0, 300);
            this.absorptionDuration = builder.comment("Duration in seconds for the Charged Absorption Charm effect.").defineInRange("absorptionDuration", 5, 1, 300);
            this.absorptionAmplifier = builder.comment("Charged Absorption Charm effect amplifier.").defineInRange("absorptionAmplifier", 0, 0, 255);
            this.absorptionCharges = builder.comment("Number of charges for the Charged Absorption Charm.").defineInRange("absorptionCharges", 15, 1, 100);
            this.regenPercentage = builder.comment("Low health percentage to trigger Charged Regeneration Charm.").defineInRange("regenPercentage", 0.35, 0.2, 0.8);
            this.regenDuration = builder.comment("Duration in seconds for the Charged Regeneration Charm effect.").defineInRange("regenDuration", 15, 1, 300);
            this.regenAmplifier = builder.comment("Charged Regeneration Charm effect amplifier.").defineInRange("regenAmplifier", 0, 0, 255);
            this.regenCharges = builder.comment("Number of charges for the Charged Regeneration Charm.").defineInRange("regenCharges", 15, 1, 100);
            this.glowUpDuration = builder.comment("Duration in seconds for the Charged Glow Up Charm effect.").defineInRange("glowUpDuration", 30, 1, 300);
            this.glowUpCharges = builder.comment("Number of charges for the Charged Glow Up Charm.").defineInRange("glowUpCharges", 20, 1, 100);
            this.speedDuration = builder.comment("Duration in seconds for the Charged Speed Charm effect.").defineInRange("speedDuration", 180, 1, 360);
            this.speedCooldown = builder.comment("Cooldown in seconds for the Charged Speed Charm.").defineInRange("speedCooldown", 120, 0, 360);
            this.speedCharges = builder.comment("Number of charges for the Charged Speed Charm.").defineInRange("speedCharges", 20, 1, 100);
            this.totemCharges = builder.comment("Number of charges for the Charged Totem Charm and Charged Enchanted Totem Charm.").defineInRange("totemCharges", 5, 1, 100);
            this.airRemaining = builder.comment("Amount of air remaining when Charged Water Breathing Charm is triggered.").defineInRange("airRemaining", 0, 0, 10);
            this.waterBreathingCharges = builder.comment("Number of charges for the Charged Water Breathing Charm.").defineInRange("waterBreathingCharges", 5, 1, 100);
            builder.pop();
        }

        public static boolean disableRegenCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableRegenCharm.get();
            }
            return false;
        }

        public static boolean disableAbsorptionCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableAbsorptionCharm.get();
            }
            return false;
        }

        public static boolean disableGlowupCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableGlowupCharm.get();
            }
            return false;
        }

        public static boolean disableTotemCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableTotemCharm.get();
            }
            return false;
        }

        public static boolean disableEnchTotemCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableEnchTotemCharm.get();
            }
            return false;
        }

        public static boolean disableSpeedCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableSpeedCharm.get();
            }
            return false;
        }

        public static boolean disableWaterBreathingCharm() {
            if (loaded) {
                return (Boolean)ConfigHandler.COMMON.disableWaterBreathingCharm.get();
            }
            return false;
        }

        public static long absorptionCooldown() {
            return (long)((Integer)ConfigHandler.COMMON.absorptionCooldown.get() + (Integer)ConfigHandler.COMMON.absorptionDuration.get()) * 1000L;
        }

        public static int absorptionDuration() {
            return (Integer)ConfigHandler.COMMON.absorptionDuration.get();
        }

        public static int absorptionAmplifier() {
            return (Integer)ConfigHandler.COMMON.absorptionAmplifier.get();
        }

        public static int absorptionCharges() {
            return (Integer)ConfigHandler.COMMON.absorptionCharges.get();
        }

        public static Float regenPercentage() {
            double regenPercentage = (Double)ConfigHandler.COMMON.regenPercentage.get();
            return Float.valueOf((float)regenPercentage);
        }

        public static int regenDuration() {
            return (Integer)ConfigHandler.COMMON.regenDuration.get();
        }

        public static int regenAmplifier() {
            return (Integer)ConfigHandler.COMMON.regenAmplifier.get();
        }

        public static int regenCharges() {
            return (Integer)ConfigHandler.COMMON.regenCharges.get();
        }

        public static int glowUpDuration() {
            return (Integer)ConfigHandler.COMMON.glowUpDuration.get();
        }

        public static int glowUpCharges() {
            return (Integer)ConfigHandler.COMMON.glowUpCharges.get();
        }

        public static int speedDuration() {
            return (Integer)ConfigHandler.COMMON.speedDuration.get();
        }

        public static long speedCooldown() {
            return (long)((Integer)ConfigHandler.COMMON.speedCooldown.get() + (Integer)ConfigHandler.COMMON.speedDuration.get()) * 1000L;
        }

        public static int speedCharges() {
            return (Integer)ConfigHandler.COMMON.speedCharges.get();
        }

        public static int totemCharges() {
            return (Integer)ConfigHandler.COMMON.totemCharges.get();
        }

        public static int airRemaining() {
            return (Integer)ConfigHandler.COMMON.airRemaining.get();
        }

        public static int waterBreathingCharges() {
            return (Integer)ConfigHandler.COMMON.waterBreathingCharges.get();
        }
    }

    public static class Client {
        private final WhiteNoiseConfigSpec.BooleanValue showCharms;

        public Client(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("rendering");
            this.showCharms = builder.comment("Show Charged Charm on player chest.").define("showCharms", true);
            builder.pop();
        }

        public static boolean showCharms() {
            return (Boolean)ConfigHandler.CLIENT.showCharms.get();
        }
    }
}

