/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.integration.accessories;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;

public class EntityData {
    private final boolean replace;
    private static final List<String> entities = new ArrayList<String>();
    private static final List<String> slots = new ArrayList<String>();

    public EntityData(boolean replace, List<TagKey<EntityType<?>>> entities, List<Slot> slots) {
        this.replace = replace;
        if (entities != null) {
            for (TagKey tagKey : entities) {
                String location = "#" + String.valueOf(tagKey.location());
                if (EntityData.entities.contains(location)) continue;
                EntityData.entities.add(location);
            }
        }
        if (slots != null) {
            for (Slot slot : slots) {
                String name = slot.toString();
                if (EntityData.slots.contains(name)) continue;
                EntityData.slots.add(name);
            }
        }
    }

    public boolean replace() {
        return this.replace;
    }

    public List<String> entities() {
        return entities;
    }

    public List<String> slots() {
        return slots;
    }

    public static enum Slot {
        ANKLET,
        BACK,
        BELT,
        CAPE,
        CHARGED_CHARM,
        CHARM,
        FACE,
        HAND,
        HAT,
        NECKLACE,
        RING,
        SHOES,
        WRIST;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static class Serializer
    implements JsonSerializer<EntityData> {
        public JsonElement serialize(EntityData entityData, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(entityData.replace()));
            if (!entityData.entities().isEmpty()) {
                JsonElement entities = jsonSerializationContext.serialize(entityData.entities());
                json.add("entities", entities);
            }
            if (!entityData.slots().isEmpty()) {
                JsonElement slots = jsonSerializationContext.serialize(entityData.slots());
                json.add("slots", slots);
            }
            return json;
        }
    }
}

