/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common;

import chargedcharms.common.effect.AbsorptionEffectProvider;
import chargedcharms.common.effect.GlowUpEffectProvider;
import chargedcharms.common.effect.ICharmEffectProvider;
import chargedcharms.common.effect.RegenerationEffectProvider;
import chargedcharms.common.effect.SpeedEffectProvider;
import chargedcharms.common.effect.VanillaTotemEffectProvider;
import chargedcharms.common.effect.WaterBreathingEffectProvider;
import chargedcharms.common.effect.integration.BMEnchantedTotemEffectProvider;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import technology.roughness.whitenoise.platform.Services;

public class CharmEffectProviders {
    private static final Map<class_2960, ICharmEffectProvider> EFFECT_PROVIDERS = new HashMap<class_2960, ICharmEffectProvider>();
    private static Set<class_2960> TOTEMS;
    private static final Predicate<class_1792> IS_TOTEM;
    public static Predicate<class_1792> IS_CHARM;

    public static void init() {
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_totem_charm"), new VanillaTotemEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_enchanted_totem_charm"), new BMEnchantedTotemEffectProvider());
        TOTEMS = ImmutableSet.copyOf(EFFECT_PROVIDERS.keySet());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_regeneration_charm"), new RegenerationEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_absorption_charm"), new AbsorptionEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_glowup_charm"), new GlowUpEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_speed_charm"), new SpeedEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_water_breathing_charm"), new WaterBreathingEffectProvider());
    }

    public static Set<class_2960> getItems() {
        return ImmutableSet.copyOf(EFFECT_PROVIDERS.keySet());
    }

    public static Optional<ICharmEffectProvider> getEffectProvider(class_1792 item) {
        return Optional.ofNullable(EFFECT_PROVIDERS.get(Services.PLATFORM.getResourceLocation(item)));
    }

    public static boolean hasTotem(class_1799 stack) {
        if (IS_TOTEM.test(stack.method_7909())) {
            return stack.method_7919() < stack.method_7936();
        }
        return false;
    }

    public static boolean hasChargedCharm(class_1799 stack, class_1792 charm) {
        return stack.method_31574(charm) && CharmEffectProviders.hasCharge(stack);
    }

    private static boolean hasCharge(class_1799 stack) {
        return !stack.method_7960() && stack.method_7919() < stack.method_7936();
    }

    static {
        IS_TOTEM = item -> TOTEMS.contains(Services.PLATFORM.getResourceLocation(item));
        IS_CHARM = item -> EFFECT_PROVIDERS.containsKey(Services.PLATFORM.getResourceLocation(item));
    }
}

