/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import com.google.gson.JsonObject;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigResourceCondition
implements ICondition {
    public static final ResourceLocation ID = ResourceLocationHelper.prefix("config_disabled");
    private final String configValue;

    public ConfigResourceCondition(String configValue) {
        this.configValue = configValue;
    }

    public static void init(BiConsumer<RecipeSerializer<?>, ResourceLocation> consumer) {
        CraftingHelper.register((IConditionSerializer)Serializer.INSTANCE);
    }

    public String toString() {
        return "config_disabled(\"" + this.configValue + "\")";
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        return !ConfigHandler.Common.getConfigValue(this.configValue);
    }

    public static class Serializer
    implements IConditionSerializer<ConfigResourceCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ConfigResourceCondition value) {
            json.addProperty("config", value.configValue);
        }

        public ConfigResourceCondition read(JsonObject json) {
            return new ConfigResourceCondition(GsonHelper.m_13906_((JsonObject)json, (String)"config"));
        }

        public ResourceLocation getID() {
            return ID;
        }
    }
}

