/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class ConsumerWrapperBuilder {
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    @Nullable
    private final RecipeSerializer<?> override;
    @Nullable
    private final ResourceLocation overrideName;

    private ConsumerWrapperBuilder(@Nullable RecipeSerializer<?> override, @Nullable ResourceLocation overrideName) {
        this.override = override;
        this.overrideName = overrideName;
    }

    public static ConsumerWrapperBuilder wrap() {
        return new ConsumerWrapperBuilder(null, null);
    }

    public static ConsumerWrapperBuilder wrap(RecipeSerializer<?> override) {
        return new ConsumerWrapperBuilder(override, null);
    }

    public static ConsumerWrapperBuilder wrap(ResourceLocation override) {
        return new ConsumerWrapperBuilder(null, override);
    }

    public ConsumerWrapperBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public Consumer<FinishedRecipe> build(Consumer<FinishedRecipe> consumer) {
        return recipe -> consumer.accept(new Wrapped((FinishedRecipe)recipe, this.conditions, this.override, this.overrideName));
    }

    private static class Wrapped
    implements FinishedRecipe {
        private final FinishedRecipe original;
        private final List<ICondition> conditions;
        @Nullable
        private final RecipeSerializer<?> override;
        @Nullable
        private final ResourceLocation overrideName;

        private Wrapped(FinishedRecipe original, List<ICondition> conditions, @Nullable RecipeSerializer<?> override, @Nullable ResourceLocation overrideName) {
            if (original instanceof Wrapped) {
                Wrapped toMerge = (Wrapped)original;
                this.original = toMerge.original;
                this.conditions = ImmutableList.builder().addAll(toMerge.conditions).addAll(conditions).build();
                if (toMerge.override != null || toMerge.overrideName != null) {
                    this.override = toMerge.override;
                    this.overrideName = toMerge.overrideName;
                } else {
                    this.override = override;
                    this.overrideName = overrideName;
                }
            } else {
                this.original = original;
                this.conditions = conditions;
                this.override = override;
                this.overrideName = overrideName;
            }
        }

        public JsonObject m_125966_() {
            JsonObject json = new JsonObject();
            if (this.overrideName != null) {
                json.addProperty("type", this.overrideName.toString());
            } else {
                ResourceLocation type = Registry.f_122865_.m_7981_(this.m_6637_());
                if (type != null) {
                    json.addProperty("type", type.toString());
                }
            }
            this.m_7917_(json);
            return json;
        }

        public void m_7917_(JsonObject json) {
            if (!this.conditions.isEmpty()) {
                JsonArray conditionsArray = new JsonArray();
                for (ICondition condition : this.conditions) {
                    conditionsArray.add((JsonElement)CraftingHelper.serialize((ICondition)condition));
                }
                json.add("conditions", (JsonElement)conditionsArray);
            }
            this.original.m_7917_(json);
        }

        public ResourceLocation m_6445_() {
            return this.original.m_6445_();
        }

        public RecipeSerializer<?> m_6637_() {
            if (this.override != null) {
                return this.override;
            }
            return this.original.m_6637_();
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.original.m_5860_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.original.m_6448_();
        }
    }
}

