/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.util;

import chargedcharms.common.CharmEffectProviders;
import chargedcharms.common.component.ChargedCharmsComponents;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3532;

public class CharmHelper {
    public static boolean useTotem(class_1309 livingEntity) {
        List<SlotEntryReference> stackSet = CharmHelper.findCharms(livingEntity);
        SlotEntryReference slotEntryReference = stackSet.stream().filter(reference -> !reference.stack().method_7960() && CharmEffectProviders.hasTotem(reference.stack())).findFirst().orElse(null);
        if (slotEntryReference != null) {
            class_1799 totem = slotEntryReference.stack();
            class_1799 copy = totem.method_7972();
            totem.method_7974(totem.method_7919() + 1);
            if (livingEntity instanceof class_3222) {
                class_3222 player = (class_3222)livingEntity;
                player.method_7342(class_3468.field_15372.method_14956((Object)class_1802.field_8288), 1);
                class_174.field_1204.method_9165(player, copy);
            }
            CharmEffectProviders.getEffectProvider(copy.method_7909()).ifPresent(effectProvider -> effectProvider.applyEffects(livingEntity));
            livingEntity.method_73183().method_8421((class_1297)livingEntity, (byte)35);
            slotEntryReference.reference().setStack(totem);
            return true;
        }
        return false;
    }

    public static void triggerCharm(class_1309 sourceEntity, class_1309 targetEntity, class_1792 charm) {
        CharmHelper.triggerCharm(targetEntity, CharmHelper.getCharm(sourceEntity, charm));
    }

    public static void triggerCharm(class_1309 targetEntity, SlotEntryReference slotEntryReference) {
        if (slotEntryReference != null) {
            class_1799 charmStack = slotEntryReference.stack();
            charmStack.method_7974(charmStack.method_7919() + 1);
            CharmEffectProviders.getEffectProvider(charmStack.method_7909()).ifPresent(effectProvider -> effectProvider.applyEffects(targetEntity));
            slotEntryReference.reference().setStack(charmStack);
        }
    }

    public static void triggerCharm(class_1309 targetEntity, class_1799 charm) {
        CharmHelper.triggerCharm(targetEntity, CharmHelper.getCharm(targetEntity, charm.method_7909()));
    }

    public static SlotEntryReference getCharm(class_1309 sourceEntity, class_1792 charm) {
        List<SlotEntryReference> stackSet = CharmHelper.findCharms(sourceEntity);
        return stackSet.stream().filter(reference -> !reference.stack().method_7960() && CharmEffectProviders.hasChargedCharm(reference.stack(), charm)).findFirst().orElse(null);
    }

    public static void chargeSolarCharm(class_3222 sp, class_1792 charm) {
        List<SlotEntryReference> stackSet = CharmHelper.findCharms((class_1309)sp);
        SlotEntryReference slotEntryReference = stackSet.stream().filter(reference -> !reference.stack().method_7960() && reference.stack().method_31574(charm) && reference.stack().method_7919() > 0).findFirst().orElse(null);
        if (slotEntryReference != null) {
            class_1799 charmStack = slotEntryReference.stack();
            int charmRadiation = (Integer)charmStack.method_58695(ChargedCharmsComponents.SOLAR_RADIATION, (Object)0);
            int radiation = (int)CharmHelper.getSunRadiation(sp.method_51469(), sp.method_23312()) + charmRadiation;
            if (radiation > 10000) {
                charmStack.method_7974(charmStack.method_7919() - 1);
                charmStack.method_57379(ChargedCharmsComponents.SOLAR_RADIATION, (Object)0);
                slotEntryReference.reference().setStack(charmStack);
            } else {
                charmStack.method_57379(ChargedCharmsComponents.SOLAR_RADIATION, (Object)radiation);
            }
        }
    }

    private static double getSunRadiation(class_3218 world, class_2338 pos) {
        double radiation = 0.0;
        double sunlight = world.method_8314(class_1944.field_9284, pos.method_10084()) - world.method_8594();
        float f = world.method_8442(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)class_3532.method_15362((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }

    private static List<SlotEntryReference> findCharms(class_1309 livingEntity) {
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)livingEntity);
        if (capability != null) {
            return capability.getEquipped(stack -> CharmEffectProviders.IS_CHARM.test(stack.method_7909()));
        }
        return List.of();
    }
}

