/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.util.ResourceLocationHelper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class RecipeProviderBase {
    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(TagKey<Item> pTag) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.item().of(pTag).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> has(ItemLike pItemLike) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.item().of(new ItemLike[]{pItemLike}).build());
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> inventoryTrigger(ItemPredicate ... predicates) {
        return CriteriaTriggers.INVENTORY_CHANGED.createCriterion((CriterionTriggerInstance)new InventoryChangeTrigger.TriggerInstance(Optional.empty(), InventoryChangeTrigger.TriggerInstance.Slots.ANY, List.of(predicates)));
    }

    public static void specialRecipe(RecipeOutput exporter, SimpleCraftingRecipeSerializer<?> serializer, Function<CraftingBookCategory, Recipe<?>> recipeFunction) {
        ResourceLocation name = BuiltInRegistries.RECIPE_SERIALIZER.getKey(serializer);
        SpecialRecipeBuilder.special(recipeFunction).save(exporter, ResourceLocationHelper.prefix("dynamic/" + Objects.requireNonNull(name).getPath()).toString());
    }

    protected static ShapedRecipeBuilder enchantedTotemCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.enchantedTotemCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('S'), TagManager.Items.ENCHANTED_TOTEMS).pattern("NNN").pattern("NSN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has(TagManager.Items.ENCHANTED_TOTEMS));
    }

    protected static ShapedRecipeBuilder regenerationCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.regenerationCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('S'), (ItemLike)Items.APPLE).pattern("NNN").pattern("NSN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.APPLE));
    }

    protected static ShapedRecipeBuilder absorptionCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.absorptionCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('A'), (ItemLike)Items.COOKED_BEEF).pattern("NNN").pattern("NAN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.COOKED_BEEF));
    }

    protected static ShapedRecipeBuilder glowupCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.glowupCharm).define(Character.valueOf('N'), (ItemLike)Items.GOLD_NUGGET).define(Character.valueOf('G'), (ItemLike)Items.GLOW_BERRIES).pattern("NNN").pattern("NGN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.GLOW_BERRIES));
    }

    protected static ShapedRecipeBuilder totemCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.totemCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('U'), (ItemLike)Items.TOTEM_OF_UNDYING).pattern("NNN").pattern("NUN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.TOTEM_OF_UNDYING));
    }

    protected static ShapedRecipeBuilder speedCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.speedCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('S'), (ItemLike)Items.SUGAR).define(Character.valueOf('B'), (ItemLike)Items.LEATHER_BOOTS).pattern("NSN").pattern("NBN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.SUGAR));
    }

    protected static ShapedRecipeBuilder waterBreathingCharm() {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.waterBreathingCharm).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).define(Character.valueOf('K'), (ItemLike)Items.KELP).pattern("NNN").pattern("NKN").pattern("NNN").unlockedBy("has_item", RecipeProviderBase.has((ItemLike)Items.KELP));
    }
}

