/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.mixin;

import chargedcharms.common.item.ChargedCharmBase;
import chargedcharms.common.item.ChargedCharmsItems;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ShapedRecipe.class})
public abstract class ShapedRecipeOverride {
    @Inject(at={@At(value="RETURN")}, method={"assemble(Lnet/minecraft/world/item/crafting/CraftingInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    private void checkAssemble(CraftingInput craftingInput, HolderLookup.Provider provider, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack resultCopy = (ItemStack)cir.getReturnValue();
        if (resultCopy.is(ChargedCharmsItems.glowupCharm)) {
            resultCopy.setDamageValue(resultCopy.getMaxDamage());
            cir.setReturnValue((Object)resultCopy);
        } else if (resultCopy.getItem() instanceof ChargedCharmBase) {
            resultCopy.setDamageValue(resultCopy.getMaxDamage() - 1);
            cir.setReturnValue((Object)resultCopy);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"assemble(Lnet/minecraft/world/item/crafting/RecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, cancellable=true)
    private void checkRecipeAssemble(RecipeInput recipeInput, HolderLookup.Provider provider, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack resultCopy = (ItemStack)cir.getReturnValue();
        if (resultCopy.is(ChargedCharmsItems.glowupCharm)) {
            resultCopy.setDamageValue(resultCopy.getMaxDamage());
            cir.setReturnValue((Object)resultCopy);
        } else if (resultCopy.getItem() instanceof ChargedCharmBase) {
            resultCopy.setDamageValue(resultCopy.getMaxDamage() - 1);
            cir.setReturnValue((Object)resultCopy);
        }
    }
}

