/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.crafting.recipe;

import chargedcharms.common.TagManager;
import chargedcharms.common.crafting.recipe.ChargeRecipeBase;
import chargedcharms.common.item.ChargedCharmsItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AbsorptionChargeRecipe
extends ChargeRecipeBase {
    public static final RecipeSerializer<AbsorptionChargeRecipe> SERIALIZER = new CustomRecipe.Serializer(AbsorptionChargeRecipe::new);

    public AbsorptionChargeRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList foods = Lists.newArrayList();
        ArrayList charms = Lists.newArrayList();
        ItemStack food = null;
        ItemStack charm = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            ItemStack stack = new ItemStack((ItemLike)ingredient.getItem());
            FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
            if (ingredient.getItem().equals(ChargedCharmsItems.absorptionCharm)) {
                charms.add(ingredient);
                if (ingredient.getDamageValue() <= 0) continue;
                charm = ingredient;
                continue;
            }
            if (ingredient.is(TagManager.Items.CHARM_FOODS_BLACKLIST) || foodProperties == null || foodProperties.nutrition() <= 4) continue;
            foods.add(ingredient);
            food = ingredient;
        }
        if (charms.size() != 1 || foods.size() != 1) {
            food = null;
            charm = null;
        }
        return Pair.of(charm, food);
    }
}

