/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.crafting.recipe;

import chargedcharms.common.crafting.recipe.ChargeRecipeBase;
import chargedcharms.common.item.ChargedCharmsItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TotemChargeRecipe
extends ChargeRecipeBase {
    public static final RecipeSerializer<TotemChargeRecipe> SERIALIZER = new CustomRecipe.Serializer(TotemChargeRecipe::new);

    public TotemChargeRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList totems = Lists.newArrayList();
        ArrayList charms = Lists.newArrayList();
        ItemStack totem = null;
        ItemStack charm = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.getItem().equals(ChargedCharmsItems.totemCharm)) {
                charms.add(ingredient);
                if (ingredient.getDamageValue() <= 0) continue;
                charm = ingredient;
                continue;
            }
            if (!ingredient.getItem().equals(Items.TOTEM_OF_UNDYING)) continue;
            totems.add(ingredient);
            totem = ingredient;
        }
        if (charms.size() != 1 || totems.size() != 1) {
            totem = null;
            charm = null;
        }
        return Pair.of(charm, totem);
    }
}

