/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.integration.accessories;

import chargedcharms.ChargedCharms;
import chargedcharms.data.integration.accessories.EntityData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.wispforest.accessories.api.data.AccessoriesTags;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class EntityDataProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final Map<ResourceLocation, EntityData> entityDataMap = new HashMap<ResourceLocation, EntityData>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(EntityData.class, (Object)new EntityData.Serializer()).create();

    public EntityDataProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerEntityData() {
        this.add(ChargedCharms.prefix("slots"), new EntityData(false, List.of(AccessoriesTags.DEFAULTED_TARGETS_BINDING), List.of(EntityData.Slot.CHARGED_CHARM)));
    }

    @NotNull
    public String getName() {
        return "Charged Charms - Accessories Entity Data";
    }

    protected void add(ResourceLocation id, EntityData entityData) {
        this.entityDataMap.put(id, entityData);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        ArrayList<CompletableFuture> outputs = new ArrayList<CompletableFuture>();
        this.registerEntityData();
        for (Map.Entry<ResourceLocation, EntityData> entry : this.entityDataMap.entrySet()) {
            Path path = this.getPathProvider(entry.getKey());
            outputs.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)GSON.toJsonTree((Object)entry.getValue()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])outputs.toArray(CompletableFuture[]::new));
    }

    private Path getPathProvider(ResourceLocation location) {
        return this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "accessories/entity").json(location);
    }
}

