/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms;

import chargedcharms.ChargedCharms;
import chargedcharms.client.CurioCharmRenderer;
import chargedcharms.common.CharmEffectProviders;
import chargedcharms.common.crafting.ChargedCharmsCrafting;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.data.recipe.ConfigResourceCondition;
import chargedcharms.util.ResourceLocationHelper;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import technology.roughness.whitenoise.platform.Services;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="chargedcharms")
@Mod.EventBusSubscriber(modid="chargedcharms")
public class ChargedCharmsForge {
    public static final ResourceLocation EMPTY_CHARGED_CHARM_SLOT = ResourceLocationHelper.prefix("item/empty_charged_charm_slot");

    public ChargedCharmsForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ChargedCharms.init();
        this.registryInit(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
        eventBus.addListener(this::buildCreativeTabContents);
        ChargedCharms.initConfig();
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        for (ResourceLocation loc : CharmEffectProviders.getItems()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
            if (item == null || item == Items.f_41852_) continue;
            CuriosRendererRegistry.register((Item)item, CurioCharmRenderer::new);
        }
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charged_charm").icon(EMPTY_CHARGED_CHARM_SLOT).size(2).build());
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent evt) {
        if (evt.getTabKey() == CreativeModeTabs.f_256869_) {
            for (Map.Entry<ResourceLocation, Item> entry : ChargedCharmsItems.getAll().entrySet()) {
                Item charm = entry.getValue();
                if (charm == ChargedCharmsItems.enchantedTotemCharm && !Services.PLATFORM.isModLoaded("biomemakeover")) {
                    charm = null;
                }
                if (charm == null) continue;
                evt.m_246342_(new ItemStack((ItemLike)charm));
            }
        }
    }

    private void attachCapabilities(final AttachCapabilitiesEvent<ItemStack> evt) {
        if (!CharmEffectProviders.IS_CHARM.test(((ItemStack)evt.getObject()).m_41720_())) {
            return;
        }
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return (ItemStack)evt.getObject();
            }

            public boolean canEquipFromUse(SlotContext ctx) {
                return true;
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        evt.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    @SubscribeEvent
    public static void initConfig(ServerStartingEvent event) {
        ConfigHandler.init();
    }

    private void registryInit(IEventBus eventBus) {
        ChargedCharmsForge.bind(ForgeRegistries.ITEMS.getRegistryKey(), ChargedCharmsItems::registerItems, eventBus);
        ChargedCharmsForge.bind(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), ChargedCharmsCrafting::registerRecipeSerializers, eventBus);
        ChargedCharmsForge.bind(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), ConfigResourceCondition::init, eventBus);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source, IEventBus eventBus) {
        eventBus.addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }
}

