/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeProviderBase
implements DataProvider {
    private final PackOutput packOutput;

    protected RecipeProviderBase(@Nullable PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    @Nullable
    public CompletableFuture<?> m_213708_(@Nullable CachedOutput cache) throws IllegalStateException {
        PackOutput.PathProvider pathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        PackOutput.PathProvider advancementPathProvider = this.packOutput.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
        HashSet resourceLocationSet = Sets.newHashSet();
        ArrayList recipeList = new ArrayList();
        this.registerRecipes(recipe -> {
            CompletableFuture<?> recipeAdvancement;
            if (!resourceLocationSet.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipe.m_6445_()));
            }
            recipeList.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)pathProvider.m_245731_(recipe.m_6445_())));
            JsonObject advancement = recipe.m_5860_();
            if (advancement != null && (recipeAdvancement = this.saveAdvancement(cache, (FinishedRecipe)recipe, advancement, advancementPathProvider)) != null) {
                recipeList.add(recipeAdvancement);
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])recipeList.toArray(CompletableFuture[]::new));
    }

    @Nullable
    protected CompletableFuture<?> saveAdvancement(CachedOutput cache, FinishedRecipe recipe, JsonObject json, PackOutput.PathProvider path) {
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.m_245731_(recipe.m_6448_()));
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    protected static InventoryChangeTrigger.TriggerInstance has(TagKey<Item> pTag) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_204145_(pTag).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance has(ItemLike pItemLike) {
        return RecipeProviderBase.inventoryTrigger(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{pItemLike}).m_45077_());
    }

    protected static InventoryChangeTrigger.TriggerInstance inventoryTrigger(ItemPredicate ... predicates) {
        return new InventoryChangeTrigger.TriggerInstance(ContextAwarePredicate.f_285567_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, predicates);
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleCraftingRecipeSerializer<?> serializer) {
        ResourceLocation name = BuiltInRegistries.f_256769_.m_7981_(serializer);
        SpecialRecipeBuilder.m_245676_(serializer).m_126359_(consumer, ResourceLocationHelper.prefix("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }

    protected static ShapedRecipeBuilder enchantedTotemCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.enchantedTotemCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_206416_(Character.valueOf('S'), TagManager.Items.ENCHANTED_TOTEMS).m_126130_("NNN").m_126130_("NSN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has(TagManager.Items.ENCHANTED_TOTEMS));
    }

    protected static ShapedRecipeBuilder regenerationCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.regenerationCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42410_).m_126130_("NNN").m_126130_("NSN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42410_));
    }

    protected static ShapedRecipeBuilder absorptionCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.absorptionCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42580_).m_126130_("NNN").m_126130_("NAN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42580_));
    }

    protected static ShapedRecipeBuilder glowupCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.glowupCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_151079_).m_126130_("NNN").m_126130_("NGN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_151079_));
    }

    protected static ShapedRecipeBuilder totemCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.totemCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('U'), (ItemLike)Items.f_42747_).m_126130_("NNN").m_126130_("NUN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42747_));
    }

    protected static ShapedRecipeBuilder speedCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.speedCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42463_).m_126130_("NSN").m_126130_("NBN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_42501_));
    }

    protected static ShapedRecipeBuilder waterBreathingCharm() {
        return ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ChargedCharmsItems.waterBreathingCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('K'), (ItemLike)Items.f_41910_).m_126130_("NNN").m_126130_("NKN").m_126130_("NNN").m_126132_("has_item", (CriterionTriggerInstance)RecipeProviderBase.has((ItemLike)Items.f_41910_));
    }
}

