/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.crafting.recipe;

import chargedcharms.common.crafting.recipe.ChargeRecipeBase;
import chargedcharms.common.item.ChargedCharmsItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class SpeedChargeRecipe
extends ChargeRecipeBase {
    public static final RecipeSerializer<SpeedChargeRecipe> SERIALIZER = new CustomRecipe.Serializer(SpeedChargeRecipe::new);

    public SpeedChargeRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    @NotNull
    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList ingredients = Lists.newArrayList();
        ArrayList charms = Lists.newArrayList();
        ItemStack sugar = null;
        ItemStack charm = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.getItem().equals(ChargedCharmsItems.speedCharm)) {
                charms.add(ingredient);
                if (ingredient.getDamageValue() <= 0) continue;
                charm = ingredient;
                continue;
            }
            if (!ingredient.getItem().equals(Items.SUGAR)) continue;
            ingredients.add(ingredient);
            sugar = ingredient;
        }
        if (charms.size() != 1 || ingredients.size() != 1) {
            sugar = null;
            charm = null;
        }
        return Pair.of(charm, sugar);
    }
}

