/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.item;

import chargedcharms.common.item.ChargedCharmBase;
import chargedcharms.common.item.EnchantedChargedCharmBase;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import io.wispforest.accessories.api.components.AccessoriesDataComponents;
import io.wispforest.accessories.api.components.AccessorySlotValidationComponent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class ChargedCharmsItems {
    private static final Map<ResourceLocation, Item> ALL = new LinkedHashMap<ResourceLocation, Item>();
    public static final String regenerationCharmId = "charged_regeneration_charm";
    public static final String absorptionCharmId = "charged_absorption_charm";
    public static final String glowupCharmId = "charged_glowup_charm";
    public static final String totemCharmId = "charged_totem_charm";
    public static final String enchantedTotemCharmId = "charged_enchanted_totem_charm";
    public static final String speedCharmId = "charged_speed_charm";
    public static final String waterBreathingCharmId = "charged_water_breathing_charm";
    public static final Item regenerationCharm = ChargedCharmsItems.make("charged_regeneration_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_regeneration_charm").durability(ConfigHandler.Common.regenCharges())));
    public static final Item absorptionCharm = ChargedCharmsItems.make("charged_absorption_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_absorption_charm").durability(ConfigHandler.Common.absorptionCharges())));
    public static final Item glowupCharm = ChargedCharmsItems.make("charged_glowup_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_glowup_charm").durability(ConfigHandler.Common.glowUpCharges())));
    public static final Item totemCharm = ChargedCharmsItems.make("charged_totem_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_totem_charm").durability(ConfigHandler.Common.totemCharges())));
    public static final Item enchantedTotemCharm = ChargedCharmsItems.make("charged_enchanted_totem_charm", new EnchantedChargedCharmBase(ChargedCharmsItems.getProps("charged_enchanted_totem_charm").durability(ConfigHandler.Common.totemCharges())));
    public static final Item speedCharm = ChargedCharmsItems.make("charged_speed_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_speed_charm").durability(ConfigHandler.Common.speedCharges())));
    public static final Item waterBreathingCharm = ChargedCharmsItems.make("charged_water_breathing_charm", new ChargedCharmBase(ChargedCharmsItems.getProps("charged_water_breathing_charm").durability(ConfigHandler.Common.waterBreathingCharges())));

    private static <T extends Item> T make(String id, T item) {
        ResourceLocation loc = ResourceLocationHelper.prefix(id);
        if (ALL.put(loc, item) != null) {
            throw new IllegalArgumentException("Duplicate Item: " + String.valueOf(loc));
        }
        return item;
    }

    public static Item.Properties getProps(String id) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocationHelper.prefix(id))).component(AccessoriesDataComponents.SLOT_VALIDATION, (Object)AccessorySlotValidationComponent.EMPTY.addValidSlot("charged_charm"));
    }

    public static void registerItems(BiConsumer<Item, ResourceLocation> consumer) {
        for (Map.Entry<ResourceLocation, Item> entry : ALL.entrySet()) {
            consumer.accept(entry.getValue(), entry.getKey());
        }
    }

    public static Map<ResourceLocation, Item> getAll() {
        return ALL;
    }
}

