/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.integration.accessories;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class SlotData {
    private static final List<String> validators = new ArrayList<String>();
    private final boolean replace;
    private final int amount;
    private final Operation operation;
    private final int order;
    private final class_2960 icon;

    public SlotData(boolean replace, int amount, Operation operation, int order, class_2960 icon, @Nullable List<Validator> validators) {
        this.replace = replace;
        this.amount = amount;
        this.operation = operation;
        this.order = order;
        this.icon = icon;
        if (validators != null) {
            for (Validator validator : validators) {
                String location = validator.location();
                if (SlotData.validators.contains(location)) continue;
                SlotData.validators.add(location);
            }
        }
    }

    public boolean replace() {
        return this.replace;
    }

    public int amount() {
        return this.amount;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int order() {
        return this.order;
    }

    public class_2960 icon() {
        return this.icon;
    }

    public List<String> validators() {
        return validators;
    }

    public static enum Operation {
        SET,
        ADD,
        REMOVE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Validator {
        TAG,
        COMPONENT,
        ATTRIBUTE,
        ELYTRA_ITEM,
        TOTEM_ITEM,
        BANNER_ITEM;


        public String toString() {
            return this.name().toLowerCase();
        }

        public String location() {
            return "accessories:" + String.valueOf((Object)this);
        }
    }

    public static class Serializer
    implements JsonSerializer<SlotData> {
        public JsonElement serialize(SlotData slotData, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject json = new JsonObject();
            json.addProperty("replace", Boolean.valueOf(slotData.replace()));
            json.addProperty("amount", (Number)slotData.amount());
            json.addProperty("operation", slotData.getOperation().toString());
            json.addProperty("order", (Number)slotData.order());
            json.addProperty("icon", slotData.icon().toString());
            if (!slotData.validators().isEmpty()) {
                JsonElement validators = jsonSerializationContext.serialize(slotData.validators());
                json.add("validators", validators);
            }
            return json;
        }
    }
}

