/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.mixin;

import chargedcharms.common.effect.AbsorptionEffectProvider;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.CharmHelper;
import com.google.common.collect.Maps;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class MixinServerPlayer {
    @Unique
    private int chargedCharms$counter = 0;
    @Unique
    private final Map<String, Map<UUID, Long>> chargedCharms$coolDownTracker = Maps.newHashMap();

    @Inject(at={@At(value="TAIL")}, method={"doTick"})
    private void monitorDoTick(CallbackInfo ci) {
        class_3222 sp = (class_3222)this;
        if (this.chargedCharms$counter % 20 == 0) {
            class_1799 charmStack;
            SlotEntryReference slotEntryReference;
            if (this.chargedCharms$needsHealing(sp) && !sp.method_6059(class_1294.field_5924)) {
                CharmHelper.triggerCharm((class_1309)sp, (class_1309)sp, ChargedCharmsItems.regenerationCharm);
            }
            if (this.chargedCharms$isSprintJumping(sp) && !sp.method_6059(class_1294.field_5904) && (slotEntryReference = CharmHelper.getCharm((class_1309)sp, ChargedCharmsItems.speedCharm)) != null && this.chargedCharms$hasCharge(charmStack = slotEntryReference.stack()) && this.chargedCharms$canTriggerSpeedCharm((class_1309)sp)) {
                CharmHelper.triggerCharm((class_1309)sp, charmStack);
            }
            if (this.chargedCharms$needsAir(sp) && !sp.method_6059(class_1294.field_5923) && (slotEntryReference = CharmHelper.getCharm((class_1309)sp, ChargedCharmsItems.waterBreathingCharm)) != null && this.chargedCharms$hasCharge(charmStack = slotEntryReference.stack())) {
                CharmHelper.triggerCharm((class_1309)sp, charmStack);
            }
        }
        if (this.chargedCharms$counter % 100 == 0) {
            CharmHelper.chargeSolarCharm(sp, ChargedCharmsItems.glowupCharm);
        }
        ++this.chargedCharms$counter;
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"})
    private void onPlayerAttack(class_1297 target, CallbackInfo ci) {
        class_1309 livingEntity;
        if (target instanceof class_1309 && !(livingEntity = (class_1309)target).method_6059(class_1294.field_5912)) {
            class_3222 sp = (class_3222)this;
            CharmHelper.triggerCharm((class_1309)sp, livingEntity, ChargedCharmsItems.glowupCharm);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isInvulnerableTo(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;)Z")}, method={"hurtServer"})
    private void onPlayerHurt(class_3218 level, class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1799 charmStack;
        SlotEntryReference slotEntryReference;
        class_3222 sp = (class_3222)this;
        if (!sp.method_5679(level, damageSource) && this.chargedCharms$isValidDamageSource(damageSource) && !sp.method_6059(class_1294.field_5898) && (slotEntryReference = CharmHelper.getCharm((class_1309)sp, ChargedCharmsItems.absorptionCharm)) != null && this.chargedCharms$hasCharge(charmStack = slotEntryReference.stack()) && this.chargedCharms$canTriggerAbsorptionCharm((class_1309)sp)) {
            CharmHelper.triggerCharm((class_1309)sp, charmStack);
        }
    }

    @Unique
    private boolean chargedCharms$isValidDamageSource(class_1282 damageSource) {
        return AbsorptionEffectProvider.invalidDamageSources.stream().noneMatch(arg_0 -> ((class_1282)damageSource).method_49708(arg_0));
    }

    @Unique
    private boolean chargedCharms$canTriggerAbsorptionCharm(class_1309 livingEntity) {
        long now = System.currentTimeMillis();
        UUID uuid = livingEntity.method_5667();
        Map absorptionCoolDownTracker = this.chargedCharms$coolDownTracker.computeIfAbsent("absorption", k -> Maps.newHashMap());
        long lastTime = absorptionCoolDownTracker.getOrDefault(uuid, now);
        long cooldown = ConfigHandler.Common.absorptionCooldown();
        long elapsed = now - lastTime;
        if (elapsed == 0L || elapsed > cooldown) {
            absorptionCoolDownTracker.put(uuid, now);
            return true;
        }
        return false;
    }

    @Unique
    private boolean chargedCharms$canTriggerSpeedCharm(class_1309 livingEntity) {
        long now = System.currentTimeMillis();
        UUID uuid = livingEntity.method_5667();
        Map speedCoolDownTracker = this.chargedCharms$coolDownTracker.computeIfAbsent("speed", k -> Maps.newHashMap());
        long lastTime = speedCoolDownTracker.getOrDefault(uuid, now);
        long cooldown = ConfigHandler.Common.speedCooldown();
        long elapsed = now - lastTime;
        if (elapsed == 0L || elapsed > cooldown) {
            speedCoolDownTracker.put(uuid, now);
            return true;
        }
        return false;
    }

    @Unique
    private boolean chargedCharms$needsHealing(class_3222 sp) {
        return sp.method_6032() / sp.method_6063() < ConfigHandler.Common.regenPercentage().floatValue();
    }

    @Unique
    private boolean chargedCharms$isSprintJumping(class_3222 sp) {
        return !sp.method_24828() && sp.method_5624() && !sp.method_5681();
    }

    @Unique
    private boolean chargedCharms$hasCharge(class_1799 charmStack) {
        return !charmStack.method_7960() && charmStack.method_7919() < charmStack.method_7936();
    }

    @Unique
    private boolean chargedCharms$needsAir(class_3222 sp) {
        return (float)sp.method_5669() / (float)sp.method_5748() <= (float)ConfigHandler.Common.airRemaining();
    }
}

