/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms;

import chargedcharms.ChargedCharms;
import chargedcharms.client.CurioCharmRenderer;
import chargedcharms.common.CharmEffectProviders;
import chargedcharms.common.crafting.ChargedCharmsCrafting;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.data.recipe.ConfigResourceCondition;
import chargedcharms.util.ResourceLocationHelper;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="chargedcharms")
public class ChargedCharmsForge {
    public static final ResourceLocation EMPTY_CHARGED_CHARM_SLOT = ResourceLocationHelper.prefix("item/empty_charged_charm_slot");

    public ChargedCharmsForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ChargedCharms.init();
        ChargedCharms.initConfig();
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::enqueue);
    }

    private void setup(FMLCommonSetupEvent evt) {
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::attachCapabilities);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        for (ResourceLocation loc : CharmEffectProviders.getItems()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(loc);
            if (item == null || item == Items.f_41852_) continue;
            CuriosRendererRegistry.register((Item)item, CurioCharmRenderer::new);
        }
    }

    private void enqueue(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("charged_charm").icon(EMPTY_CHARGED_CHARM_SLOT).size(2).build());
    }

    private void attachCapabilities(final AttachCapabilitiesEvent<ItemStack> evt) {
        if (!CharmEffectProviders.IS_CHARM.test(((ItemStack)evt.getObject()).m_41720_())) {
            return;
        }
        final ICurio curio = new ICurio(){

            public ItemStack getStack() {
                return (ItemStack)evt.getObject();
            }

            public boolean canEquipFromUse(SlotContext ctx) {
                return true;
            }
        };
        ICapabilityProvider provider = new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOpt = LazyOptional.of(() -> curio);

            @NotNull
            public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOpt);
            }
        };
        evt.addCapability(CuriosCapability.ID_ITEM, provider);
    }

    @SubscribeEvent
    public static void initConfig(ServerStartingEvent event) {
        ConfigHandler.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            ChargedCharmsItems.registerItems((item, rl) -> event.getRegistry().register((IForgeRegistryEntry)((Item)item.setRegistryName(rl))));
        }

        @SubscribeEvent
        public static void onRecipeRegistry(RegistryEvent.Register<RecipeSerializer<?>> event) {
            ChargedCharmsCrafting.registerRecipeSerializers((t, rl) -> event.getRegistry().register((IForgeRegistryEntry)((RecipeSerializer)t.setRegistryName(rl))));
            ConfigResourceCondition.init((t, rl) -> event.getRegistry().register((IForgeRegistryEntry)t));
        }
    }

    @Mod.EventBusSubscriber(modid="chargedcharms", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientProxy {
        @SubscribeEvent
        public static void textureStitch(TextureStitchEvent.Pre event) {
            if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
                event.addSprite(EMPTY_CHARGED_CHARM_SLOT);
            }
        }
    }
}

