/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import technology.roughness.whitenoise.platform.Services;

public class CharmChargingRecipeMaker {
    public static List<CraftingRecipe> createRecipes(String plugin) {
        String group = plugin + ".charm.charging";
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ArrayList regenFoods = Lists.newArrayList();
        ArrayList absorptionFoods = Lists.newArrayList();
        Registry.f_122827_.m_123024_().filter(Item::m_41472_).filter(item -> {
            List effects = Objects.requireNonNull(item.m_41473_()).m_38749_();
            if (!effects.isEmpty()) {
                return effects.stream().noneMatch(props -> ((MobEffectInstance)props.getFirst()).m_19544_().equals(MobEffects.f_19614_));
            }
            return true;
        }).forEach(food -> {
            ItemStack foodStack = new ItemStack((ItemLike)food);
            if (!foodStack.m_204117_(TagManager.Items.CHARM_FOODS_BLACKLIST) && foodStack.m_41614_()) {
                if (food.m_41473_().m_38744_() > 4) {
                    absorptionFoods.add(foodStack);
                }
                regenFoods.add(foodStack);
            }
        });
        if (!ConfigHandler.Common.disableRegenCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".regen", ChargedCharmsItems.regenerationCharm, Ingredient.m_43921_(regenFoods.stream())));
        }
        if (!ConfigHandler.Common.disableAbsorptionCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".absorption", ChargedCharmsItems.absorptionCharm, Ingredient.m_43921_(absorptionFoods.stream())));
        }
        if (!ConfigHandler.Common.disableTotemCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".totem", ChargedCharmsItems.totemCharm, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42747_})));
        }
        if (Services.PLATFORM.isModLoaded("biomemakeover") && !ConfigHandler.Common.disableEnchTotemCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".enchanted_totem", ChargedCharmsItems.enchantedTotemCharm, Ingredient.m_204132_(TagManager.Items.ENCHANTED_TOTEMS)));
        }
        if (!ConfigHandler.Common.disableSpeedCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".speed", ChargedCharmsItems.speedCharm, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42501_})));
        }
        if (!ConfigHandler.Common.disableWaterBreathingCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".water_breathing", ChargedCharmsItems.waterBreathingCharm, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41910_})));
        }
        return recipes;
    }

    private static CraftingRecipe getRecipe(String group, String label, Item charm, Ingredient chargeItems) {
        ItemStack unchargedCharm = new ItemStack((ItemLike)charm);
        unchargedCharm.m_41721_(unchargedCharm.m_41776_());
        Ingredient baseCharm = Ingredient.m_43927_((ItemStack[])new ItemStack[]{unchargedCharm});
        ItemStack chargedCharm = unchargedCharm.m_41777_();
        chargedCharm.m_41721_(chargedCharm.m_41776_() - 1);
        NonNullList chargedCharmInputs = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{baseCharm, chargeItems});
        return new ShapelessRecipe(ResourceLocationHelper.prefix(group + label), group, chargedCharm, chargedCharmInputs);
    }
}

