/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common;

import chargedcharms.common.effect.AbsorptionEffectProvider;
import chargedcharms.common.effect.GlowUpEffectProvider;
import chargedcharms.common.effect.ICharmEffectProvider;
import chargedcharms.common.effect.RegenerationEffectProvider;
import chargedcharms.common.effect.SpeedEffectProvider;
import chargedcharms.common.effect.VanillaTotemEffectProvider;
import chargedcharms.common.effect.WaterBreathingEffectProvider;
import chargedcharms.common.effect.integration.BMEnchantedTotemEffectProvider;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import technology.roughness.whitenoise.platform.Services;

public class CharmEffectProviders {
    private static final Map<ResourceLocation, ICharmEffectProvider> EFFECT_PROVIDERS = new HashMap<ResourceLocation, ICharmEffectProvider>();
    private static Set<ResourceLocation> TOTEMS;
    private static final Predicate<Item> IS_TOTEM;
    public static Predicate<Item> IS_CHARM;

    public static void init() {
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_totem_charm"), new VanillaTotemEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_enchanted_totem_charm"), new BMEnchantedTotemEffectProvider());
        TOTEMS = ImmutableSet.copyOf(EFFECT_PROVIDERS.keySet());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_regeneration_charm"), new RegenerationEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_absorption_charm"), new AbsorptionEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_glowup_charm"), new GlowUpEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_speed_charm"), new SpeedEffectProvider());
        EFFECT_PROVIDERS.put(ResourceLocationHelper.prefix("charged_water_breathing_charm"), new WaterBreathingEffectProvider());
    }

    public static Set<ResourceLocation> getItems() {
        return ImmutableSet.copyOf(EFFECT_PROVIDERS.keySet());
    }

    public static Optional<ICharmEffectProvider> getEffectProvider(Item item) {
        return Optional.ofNullable(EFFECT_PROVIDERS.get(Services.PLATFORM.getResourceLocation(item)));
    }

    public static boolean hasTotem(ItemStack stack) {
        if (IS_TOTEM.test(stack.m_41720_())) {
            return stack.m_41773_() < stack.m_41776_();
        }
        return false;
    }

    public static boolean hasChargedCharm(ItemStack stack, Item charm) {
        return stack.m_150930_(charm) && CharmEffectProviders.hasCharge(stack);
    }

    private static boolean hasCharge(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41773_() < stack.m_41776_();
    }

    static {
        IS_TOTEM = item -> TOTEMS.contains(Services.PLATFORM.getResourceLocation(item));
        IS_CHARM = item -> EFFECT_PROVIDERS.containsKey(Services.PLATFORM.getResourceLocation(item));
    }
}

