/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.mixin.RecipeProviderAccessor;
import chargedcharms.platform.Services;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class RecipeProviderBase
implements DataProvider {
    private final DataGenerator generator;

    protected RecipeProviderBase(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IllegalStateException {
        Path path = this.generator.m_123916_();
        HashSet recipes = Sets.newHashSet();
        this.registerRecipes(provider -> {
            if (recipes.add(provider.m_6445_())) {
                JsonObject advancement = provider.m_5860_();
                RecipeProviderAccessor.callSaveRecipe(cache, provider.m_125966_(), path.resolve("data/" + provider.m_6445_().m_135827_() + "/recipes/" + provider.m_6445_().m_135815_() + ".json"));
                if (advancement != null) {
                    Services.PLATFORM.saveRecipeAdvancement(this.generator, cache, advancement, path.resolve("data/" + provider.m_6445_().m_135827_() + "/advancements/" + provider.m_6448_().m_135815_() + ".json"));
                }
            } else {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(provider.m_6445_()));
            }
        });
    }

    protected abstract void registerRecipes(Consumer<FinishedRecipe> var1);

    public static InventoryChangeTrigger.TriggerInstance conditionsFromItem(ItemLike item) {
        return RecipeProviderAccessor.cc_condition(ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{item}).m_45077_());
    }

    public static InventoryChangeTrigger.TriggerInstance conditionsFromTag(TagKey<Item> key) {
        return RecipeProviderAccessor.cc_condition(ItemPredicate.Builder.m_45068_().m_204145_(key).m_45077_());
    }

    protected static void specialRecipe(Consumer<FinishedRecipe> consumer, SimpleRecipeSerializer<?> serializer) {
        ResourceLocation name = Registry.f_122865_.m_7981_(serializer);
        SpecialRecipeBuilder.m_126357_(serializer).m_126359_(consumer, ResourceLocationHelper.prefix("dynamic/" + Objects.requireNonNull(name).m_135815_()).toString());
    }

    protected static ShapedRecipeBuilder enchantedTotemCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.enchantedTotemCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_206416_(Character.valueOf('S'), TagManager.Items.ENCHANTED_TOTEMS).m_126130_("NNN").m_126130_("NSN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromTag(TagManager.Items.ENCHANTED_TOTEMS));
    }

    protected static ShapedRecipeBuilder regenerationCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.regenerationCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42410_).m_126130_("NNN").m_126130_("NSN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_42410_));
    }

    protected static ShapedRecipeBuilder absorptionCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.absorptionCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_42580_).m_126130_("NNN").m_126130_("NAN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_42580_));
    }

    protected static ShapedRecipeBuilder glowupCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.glowupCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42587_).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_151079_).m_126130_("NNN").m_126130_("NGN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_151079_));
    }

    protected static ShapedRecipeBuilder totemCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.totemCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('U'), (ItemLike)Items.f_42747_).m_126130_("NNN").m_126130_("NUN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_42747_));
    }

    protected static ShapedRecipeBuilder speedCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.speedCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42501_).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42463_).m_126130_("NSN").m_126130_("NBN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_42501_));
    }

    protected static ShapedRecipeBuilder waterBreathingCharm() {
        return ShapedRecipeBuilder.m_126116_((ItemLike)ChargedCharmsItems.waterBreathingCharm).m_126127_(Character.valueOf('N'), (ItemLike)Items.f_42749_).m_126127_(Character.valueOf('K'), (ItemLike)Items.f_41910_).m_126130_("NNN").m_126130_("NKN").m_126130_("NNN").m_142284_("has_item", (CriterionTriggerInstance)RecipeProviderBase.conditionsFromItem((ItemLike)Items.f_41910_));
    }
}

