/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.util;

import chargedcharms.common.CharmEffectProviders;
import chargedcharms.platform.Services;
import java.util.Set;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.LightLayer;

public class CharmHelper {
    public static boolean useTotem(LivingEntity livingEntity) {
        Set<ItemStack> stackSet = Services.PLATFORM.findCharms(livingEntity);
        ItemStack totem = stackSet.stream().filter(stack -> !stack.m_41619_() && CharmEffectProviders.hasTotem(stack)).findFirst().orElse(ItemStack.f_41583_);
        if (!totem.m_41619_()) {
            ItemStack copy = totem.m_41777_();
            totem.m_41721_(totem.m_41773_() + 1);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_6278_(Stats.f_12982_.m_12902_((Object)Items.f_42747_), 1);
                CriteriaTriggers.f_10551_.m_74431_(player, copy);
            }
            CharmEffectProviders.getEffectProvider(copy.m_41720_()).ifPresent(effectProvider -> effectProvider.applyEffects(livingEntity));
            livingEntity.f_19853_.m_7605_((Entity)livingEntity, (byte)35);
            return true;
        }
        return false;
    }

    public static void triggerCharm(LivingEntity sourceEntity, LivingEntity targetEntity, Item charm) {
        ItemStack charmStack = CharmHelper.getCharm(sourceEntity, charm);
        CharmHelper.triggerCharm(targetEntity, charmStack);
    }

    public static void triggerCharm(LivingEntity targetEntity, ItemStack charmStack) {
        if (!charmStack.m_41619_()) {
            charmStack.m_41721_(charmStack.m_41773_() + 1);
            CharmEffectProviders.getEffectProvider(charmStack.m_41720_()).ifPresent(effectProvider -> effectProvider.applyEffects(targetEntity));
        }
    }

    public static ItemStack getCharm(LivingEntity sourceEntity, Item charm) {
        Set<ItemStack> stackSet = Services.PLATFORM.findCharms(sourceEntity);
        return stackSet.stream().filter(stack -> !stack.m_41619_() && CharmEffectProviders.hasChargedCharm(stack, charm)).findFirst().orElse(ItemStack.f_41583_);
    }

    public static void chargeSolarCharm(ServerPlayer sp, Item charm) {
        Set<ItemStack> stackSet = Services.PLATFORM.findCharms((LivingEntity)sp);
        ItemStack charmStack = stackSet.stream().filter(stack -> !stack.m_41619_() && stack.m_150930_(charm) && stack.m_41773_() > 0).findFirst().orElse(ItemStack.f_41583_);
        if (!charmStack.m_41619_()) {
            CompoundTag tags = charmStack.m_41784_();
            double radiation = CharmHelper.getSunRadiation(sp.m_183503_(), sp.m_20097_());
            String key = "solar_radiation";
            if (tags.m_128441_(key)) {
                radiation += tags.m_128459_(key);
            }
            if (radiation > 10000.0) {
                charmStack.m_41721_(charmStack.m_41773_() - 1);
                tags.m_128347_(key, 0.0);
            } else {
                tags.m_128347_(key, radiation);
            }
        }
    }

    private static double getSunRadiation(ServerLevel world, BlockPos pos) {
        double radiation = 0.0;
        double sunlight = world.m_45517_(LightLayer.SKY, pos.m_7494_()) - world.m_7445_();
        float f = world.m_46490_(1.0f);
        if (sunlight > 0.0) {
            float f1 = f < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            f += (f1 - f) * 0.2f;
            sunlight *= (double)Mth.m_14089_((float)f);
        }
        return Math.max(radiation += sunlight * 100.0, 0.0);
    }
}

