/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms;

import chargedcharms.ChargedCharms;
import chargedcharms.client.CurioCharmRenderer;
import chargedcharms.client.integration.arsnouveau.ArsDynamicLightsModule;
import chargedcharms.client.integration.ryoamiclights.RyoamicDynamicLightsModule;
import chargedcharms.common.CharmEffectProviders;
import chargedcharms.common.component.ChargedCharmsComponents;
import chargedcharms.common.crafting.ChargedCharmsCrafting;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.data.recipe.ConfigResourceCondition;
import chargedcharms.registries.ChargedCharmsNeoForgeRegistries;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import technology.roughness.whitenoise.platform.Services;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod(value="chargedcharms")
@EventBusSubscriber(modid="chargedcharms")
public class ChargedCharmsNeoForge {
    public ChargedCharmsNeoForge(IEventBus eventBus) {
        ChargedCharms.initConfig();
        ChargedCharmsNeoForge.registryInit(eventBus);
        eventBus.addListener(this::registerCapabilities);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::buildCreativeTabContents);
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        for (ResourceLocation loc : CharmEffectProviders.getItems()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(loc);
            CuriosRendererRegistry.register((Item)item, CurioCharmRenderer::new);
        }
        if (Services.PLATFORM.isModLoaded("ars_nouveau")) {
            ArsDynamicLightsModule.setup();
        }
        if (Services.PLATFORM.isModLoaded("ryoamiclights")) {
            RyoamicDynamicLightsModule.setup();
        }
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            for (Map.Entry<ResourceLocation, Item> entry : ChargedCharmsItems.getAll().entrySet()) {
                Item charm = entry.getValue();
                if (charm == ChargedCharmsItems.enchantedTotemCharm && !Services.PLATFORM.isModLoaded("biomemakeover")) {
                    charm = null;
                }
                if (charm == null) continue;
                event.accept(new ItemStack((ItemLike)charm));
            }
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent evt) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!CharmEffectProviders.IS_CHARM.test(item)) continue;
            evt.registerItem(CuriosCapability.ITEM, (stack, ctx) -> new ICurio(){
                final /* synthetic */ ItemStack val$stack;
                {
                    this.val$stack = itemStack;
                }

                public ItemStack getStack() {
                    return this.val$stack;
                }

                public boolean canEquipFromUse(SlotContext ctx) {
                    return true;
                }
            }, new ItemLike[]{item});
        }
    }

    private static void registryInit(IEventBus eventBus) {
        ChargedCharmsNeoForge.bind(eventBus, Registries.ITEM, ChargedCharmsItems::registerItems);
        ChargedCharmsNeoForge.bind(eventBus, Registries.RECIPE_SERIALIZER, ChargedCharmsCrafting::registerRecipeSerializers);
        ChargedCharmsNeoForgeRegistries.CONDITION_SERIALIZERS_DEFERRED_REGISTER.register(eventBus);
        ChargedCharmsNeoForgeRegistries.CONDITION_SERIALIZERS_DEFERRED_REGISTER.register("config_disabled", () -> ConfigResourceCondition.CODEC);
        ChargedCharmsNeoForgeRegistries.COMPONENT_TYPE_DEFERRED_REGISTER.register(eventBus);
        ChargedCharmsComponents.registerDataComponents();
    }

    @SubscribeEvent
    public static void initConfig(ServerStartingEvent event) {
        ConfigHandler.init();
    }

    private static <T> void bind(IEventBus eventBus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        eventBus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }
}

