/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.crafting.recipe;

import chargedcharms.common.crafting.recipe.ChargeRecipeBase;
import chargedcharms.common.item.ChargedCharmsItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;

public class WaterBreathingChargeRecipe
extends ChargeRecipeBase {
    public static final SimpleCraftingRecipeSerializer<WaterBreathingChargeRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(WaterBreathingChargeRecipe::new);

    public WaterBreathingChargeRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList ingredients = Lists.newArrayList();
        ArrayList charms = Lists.newArrayList();
        ItemStack kelp = null;
        ItemStack charm = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.getItem().equals(ChargedCharmsItems.waterBreathingCharm)) {
                charms.add(ingredient);
                if (ingredient.getDamageValue() <= 0) continue;
                charm = ingredient;
                continue;
            }
            if (!ingredient.getItem().equals(Items.KELP)) continue;
            ingredients.add(ingredient);
            kelp = ingredient;
        }
        if (charms.size() != 1 || ingredients.size() != 1) {
            kelp = null;
            charm = null;
        }
        return Pair.of(charm, kelp);
    }
}

