/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.mixin;

import chargedcharms.common.effect.AbsorptionEffectProvider;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.CharmHelper;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class MixinServerPlayer {
    @Unique
    private int chargedCharms$counter = 0;
    @Unique
    private final Map<UUID, Long> chargedCharms$absorptionCoolDownTracker = Maps.newHashMap();
    @Unique
    private final Map<UUID, Long> chargedCharms$speedCoolDownTracker = Maps.newHashMap();

    @Inject(at={@At(value="TAIL")}, method={"doTick"})
    private void monitorDoTick(CallbackInfo ci) {
        ServerPlayer sp = (ServerPlayer)this;
        if (this.chargedCharms$counter % 20 == 0) {
            ItemStack charmStack;
            if (this.chargedCharms$needsHealing(sp) && !sp.hasEffect(MobEffects.REGENERATION)) {
                CharmHelper.triggerCharm((LivingEntity)sp, (LivingEntity)sp, ChargedCharmsItems.regenerationCharm);
            }
            if (this.chargedCharms$isSprintJumping(sp) && !sp.hasEffect(MobEffects.MOVEMENT_SPEED) && this.chargedCharms$hasCharge(charmStack = CharmHelper.getCharm((LivingEntity)sp, ChargedCharmsItems.speedCharm)) && this.chargedCharms$canTriggerSpeedCharm((LivingEntity)sp)) {
                CharmHelper.triggerCharm((LivingEntity)sp, charmStack);
            }
            if (this.chargedCharms$needsAir(sp) && !sp.hasEffect(MobEffects.WATER_BREATHING) && this.chargedCharms$hasCharge(charmStack = CharmHelper.getCharm((LivingEntity)sp, ChargedCharmsItems.waterBreathingCharm))) {
                CharmHelper.triggerCharm((LivingEntity)sp, charmStack);
            }
        }
        if (this.chargedCharms$counter % 100 == 0) {
            CharmHelper.chargeSolarCharm(sp, ChargedCharmsItems.glowupCharm);
        }
        ++this.chargedCharms$counter;
    }

    @Inject(at={@At(value="HEAD")}, method={"attack"})
    private void onPlayerAttack(Entity target, CallbackInfo ci) {
        LivingEntity livingEntity;
        if (target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).hasEffect(MobEffects.GLOWING)) {
            ServerPlayer sp = (ServerPlayer)this;
            CharmHelper.triggerCharm((LivingEntity)sp, livingEntity, ChargedCharmsItems.glowupCharm);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;isInvulnerableTo(Lnet/minecraft/world/damagesource/DamageSource;)Z")}, method={"hurt"})
    private void onPlayerHurt(DamageSource damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        ItemStack charmStack;
        ServerPlayer sp = (ServerPlayer)this;
        if (!sp.isInvulnerableTo(damageSource) && this.chargedCharms$isValidDamageSource(damageSource) && !sp.hasEffect(MobEffects.ABSORPTION) && this.chargedCharms$hasCharge(charmStack = CharmHelper.getCharm((LivingEntity)sp, ChargedCharmsItems.absorptionCharm)) && this.chargedCharms$canTriggerAbsorptionCharm((LivingEntity)sp)) {
            CharmHelper.triggerCharm((LivingEntity)sp, charmStack);
        }
    }

    @Unique
    private boolean chargedCharms$isValidDamageSource(DamageSource damageSource) {
        return AbsorptionEffectProvider.invalidDamageSources.stream().noneMatch(arg_0 -> ((DamageSource)damageSource).is(arg_0));
    }

    @Unique
    private boolean chargedCharms$canTriggerAbsorptionCharm(LivingEntity livingEntity) {
        long now = System.currentTimeMillis();
        UUID uuid = livingEntity.getUUID();
        long lastTime = this.chargedCharms$absorptionCoolDownTracker.getOrDefault(uuid, now);
        long cooldown = ConfigHandler.Common.absorptionCooldown();
        long elapsed = now - lastTime;
        if (elapsed == 0L || elapsed > cooldown) {
            this.chargedCharms$absorptionCoolDownTracker.put(uuid, now);
            return true;
        }
        return false;
    }

    @Unique
    private boolean chargedCharms$canTriggerSpeedCharm(LivingEntity livingEntity) {
        long now = System.currentTimeMillis();
        UUID uuid = livingEntity.getUUID();
        long lastTime = this.chargedCharms$speedCoolDownTracker.getOrDefault(uuid, now);
        long cooldown = ConfigHandler.Common.speedCooldown();
        long elapsed = now - lastTime;
        if (elapsed == 0L || elapsed > cooldown) {
            this.chargedCharms$speedCoolDownTracker.put(uuid, now);
            return true;
        }
        return false;
    }

    @Unique
    private boolean chargedCharms$needsHealing(ServerPlayer sp) {
        return sp.getHealth() / sp.getMaxHealth() < ConfigHandler.Common.regenPercentage().floatValue();
    }

    @Unique
    private boolean chargedCharms$isSprintJumping(ServerPlayer sp) {
        return !sp.onGround() && sp.isSprinting() && !sp.isSwimming();
    }

    @Unique
    private boolean chargedCharms$hasCharge(ItemStack charmStack) {
        return !charmStack.isEmpty() && charmStack.getDamageValue() < charmStack.getMaxDamage();
    }

    @Unique
    private boolean chargedCharms$needsAir(ServerPlayer sp) {
        return (float)sp.getAirSupply() / (float)sp.getMaxAirSupply() <= (float)ConfigHandler.Common.airRemaining();
    }
}

