/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.RegistryHelper;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import technology.roughness.whitenoise.platform.Services;

public class CharmChargingRecipeMaker {
    public static List<RecipeHolder<CraftingRecipe>> createRecipes(String plugin) {
        String group = plugin + ".charm.charging";
        ArrayList<RecipeHolder<CraftingRecipe>> recipes = new ArrayList<RecipeHolder<CraftingRecipe>>();
        ArrayList regenFoods = Lists.newArrayList();
        ArrayList absorptionFoods = Lists.newArrayList();
        RegistryHelper.getRegistry(Registries.ITEM).stream().filter(item -> {
            ItemStack stack = new ItemStack((ItemLike)item);
            return stack.has(DataComponents.FOOD);
        }).filter(item -> {
            ItemStack foodStack = new ItemStack((ItemLike)item);
            List effects = null;
            FoodProperties foodProperties = (FoodProperties)foodStack.get(DataComponents.FOOD);
            if (foodProperties != null) {
                effects = foodProperties.effects();
            }
            if (effects != null && !effects.isEmpty()) {
                return effects.stream().noneMatch(props -> props.effect().equals((Object)MobEffects.POISON));
            }
            return true;
        }).forEach(food -> {
            ItemStack foodStack = new ItemStack((ItemLike)food);
            FoodProperties foodProperties = (FoodProperties)foodStack.get(DataComponents.FOOD);
            if (!foodStack.is(TagManager.Items.CHARM_FOODS_BLACKLIST) && foodProperties != null) {
                if (foodProperties.nutrition() > 4) {
                    absorptionFoods.add(foodStack);
                }
                regenFoods.add(foodStack);
            }
        });
        if (!ConfigHandler.Common.disableRegenCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".regen", ChargedCharmsItems.regenerationCharm, Ingredient.of(regenFoods.stream())));
        }
        if (!ConfigHandler.Common.disableAbsorptionCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".absorption", ChargedCharmsItems.absorptionCharm, Ingredient.of(absorptionFoods.stream())));
        }
        if (!ConfigHandler.Common.disableTotemCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".totem", ChargedCharmsItems.totemCharm, Ingredient.of((ItemLike[])new ItemLike[]{Items.TOTEM_OF_UNDYING})));
        }
        if (Services.PLATFORM.isModLoaded("biomemakeover") && !ConfigHandler.Common.disableEnchTotemCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".enchanted_totem", ChargedCharmsItems.enchantedTotemCharm, Ingredient.of(TagManager.Items.ENCHANTED_TOTEMS)));
        }
        if (!ConfigHandler.Common.disableSpeedCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".speed", ChargedCharmsItems.speedCharm, Ingredient.of((ItemLike[])new ItemLike[]{Items.SUGAR})));
        }
        if (!ConfigHandler.Common.disableWaterBreathingCharm()) {
            recipes.add(CharmChargingRecipeMaker.getRecipe(group, ".water_breathing", ChargedCharmsItems.waterBreathingCharm, Ingredient.of((ItemLike[])new ItemLike[]{Items.KELP})));
        }
        return recipes;
    }

    private static RecipeHolder<CraftingRecipe> getRecipe(String group, String label, Item charm, Ingredient chargeItems) {
        ItemStack unchargedCharm = new ItemStack((ItemLike)charm);
        unchargedCharm.setDamageValue(unchargedCharm.getMaxDamage());
        Ingredient baseCharm = Ingredient.of((ItemStack[])new ItemStack[]{unchargedCharm});
        ItemStack chargedCharm = unchargedCharm.copy();
        chargedCharm.setDamageValue(chargedCharm.getMaxDamage() - 1);
        NonNullList chargedCharmInputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{baseCharm, chargeItems});
        return new RecipeHolder(ResourceLocationHelper.prefix(group + label), (Recipe)new ShapelessRecipe(group, CraftingBookCategory.MISC, chargedCharm, chargedCharmInputs));
    }
}

