/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import top.theillusivec4.curios.api.CuriosApi;

public abstract class DynamicLightsModule {
    private final Set<EntityType<?>> processed = new HashSet();

    protected abstract int getLuminance(ItemStack var1, boolean var2);

    protected abstract void registerDynamicLight(EntityType<?> var1, Function<Entity, Integer> var2);

    public void registerEntity(Entity entity, Level level) {
        LivingEntity livingEntity;
        EntityType type;
        if (level.isClientSide() && entity instanceof LivingEntity && !this.processed.contains(type = (livingEntity = (LivingEntity)entity).getType())) {
            this.processed.add(type);
            this.registerDynamicLight(type, lEntity -> this.getLuminance((Entity)lEntity, stack -> this.getLuminance((ItemStack)stack, lEntity.isInWater())));
        }
    }

    public int getLuminance(Entity entity, Function<ItemStack, Integer> lightFunction) {
        AtomicInteger luminance = new AtomicInteger();
        luminance.set(0);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(inventory -> {
                IItemHandlerModifiable itemHandler = inventory.getEquippedCurios();
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    luminance.set(Math.max(luminance.get(), (Integer)lightFunction.apply(itemHandler.getStackInSlot(i))));
                }
                return luminance.get();
            }).orElse(luminance.get());
        }
        return luminance.get();
    }
}

