/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration.jei;

import chargedcharms.ChargedCharms;
import chargedcharms.client.integration.CharmChargingRecipeMaker;
import chargedcharms.common.crafting.recipe.AbsorptionChargeRecipe;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import technology.roughness.whitenoise.platform.Services;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocationHelper.prefix("jei_plugin");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        Minecraft minecraft = Minecraft.getInstance();
        RecipeManager recipeManager = Objects.requireNonNull(minecraft.level).getRecipeManager();
        List allCraftingRecipes = recipeManager.getAllRecipesFor(RecipeType.CRAFTING);
        List<RecipeHolder<CraftingRecipe>> charmChargingRecipes = JEIPlugin.addChargingRecipes(allCraftingRecipes);
        registration.addRecipes(RecipeTypes.CRAFTING, charmChargingRecipes);
        if (!Services.PLATFORM.isModLoaded("biomemakeover") || ConfigHandler.Common.disableEnchTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.enchantedTotemCharm)));
        }
        if (ConfigHandler.Common.disableRegenCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.regenerationCharm)));
        }
        if (ConfigHandler.Common.disableAbsorptionCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.absorptionCharm)));
        }
        if (ConfigHandler.Common.disableGlowupCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.glowupCharm)));
        }
        if (ConfigHandler.Common.disableTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.totemCharm)));
        }
        if (ConfigHandler.Common.disableSpeedCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.speedCharm)));
        }
        if (ConfigHandler.Common.disableWaterBreathingCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.waterBreathingCharm)));
        }
    }

    private static List<RecipeHolder<CraftingRecipe>> addChargingRecipes(List<RecipeHolder<CraftingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>> replacers = new IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>>();
        replacers.put(AbsorptionChargeRecipe.class, () -> CharmChargingRecipeMaker.createRecipes("jei"));
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(CraftingRecipe::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                ChargedCharms.LOGGER.error("Failed to create JEI Recipes for " + String.valueOf(recipeClass) + " " + String.valueOf(e));
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }
}

