/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.common.crafting.recipe;

import chargedcharms.common.TagManager;
import chargedcharms.common.crafting.recipe.ChargeRecipeBase;
import chargedcharms.common.item.ChargedCharmsItems;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;

public class EnchantedTotemChargeRecipe
extends ChargeRecipeBase {
    public static final SimpleCraftingRecipeSerializer<EnchantedTotemChargeRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(EnchantedTotemChargeRecipe::new);

    public EnchantedTotemChargeRecipe(CraftingBookCategory category) {
        super(category);
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public Pair<ItemStack, ItemStack> checkContainer(CraftingInput craftingInput) {
        ArrayList totems = Lists.newArrayList();
        ArrayList charms = Lists.newArrayList();
        ItemStack totem = null;
        ItemStack charm = null;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack ingredient = craftingInput.getItem(i);
            if (ingredient.getItem().equals(ChargedCharmsItems.enchantedTotemCharm)) {
                charms.add(ingredient);
                if (ingredient.getDamageValue() <= 0) continue;
                charm = ingredient;
                continue;
            }
            if (!ingredient.is(TagManager.Items.ENCHANTED_TOTEMS)) continue;
            totems.add(ingredient);
            totem = ingredient;
        }
        if (charms.size() != 1 || totems.size() != 1) {
            totem = null;
            charm = null;
        }
        return Pair.of(charm, totem);
    }
}

