/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.common.crafting.recipe.AbsorptionChargeRecipe;
import chargedcharms.common.crafting.recipe.EnchantedTotemChargeRecipe;
import chargedcharms.common.crafting.recipe.RegenerationChargeRecipe;
import chargedcharms.common.crafting.recipe.SpeedChargeRecipe;
import chargedcharms.common.crafting.recipe.TotemChargeRecipe;
import chargedcharms.common.crafting.recipe.WaterBreathingChargeRecipe;
import chargedcharms.data.recipe.ConfigResourceCondition;
import chargedcharms.data.recipe.RecipeProviderBase;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.jetbrains.annotations.NotNull;

public class NeoForgeRecipeProvider
extends RecipeProvider {
    public NeoForgeRecipeProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    public void buildRecipes(RecipeOutput recipeOutput) {
        RecipeOutput bmoWrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("biomemakeover"), new ConfigResourceCondition("disableEnchTotemCharm")});
        RecipeProviderBase.regenerationCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableRegenCharm")}));
        RecipeProviderBase.absorptionCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableAbsorptionCharm")}));
        RecipeProviderBase.glowupCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableGlowupCharm")}));
        RecipeProviderBase.totemCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableTotemCharm")}));
        RecipeProviderBase.enchantedTotemCharm().save(bmoWrapped);
        RecipeProviderBase.speedCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableSpeedCharm")}));
        RecipeProviderBase.waterBreathingCharm().save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableWaterBreathingCharm")}));
        RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableRegenCharm")}), RegenerationChargeRecipe.SERIALIZER, RegenerationChargeRecipe::new);
        RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableTotemCharm")}), TotemChargeRecipe.SERIALIZER, TotemChargeRecipe::new);
        RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableAbsorptionCharm")}), AbsorptionChargeRecipe.SERIALIZER, AbsorptionChargeRecipe::new);
        RecipeProviderBase.specialRecipe(bmoWrapped, EnchantedTotemChargeRecipe.SERIALIZER, EnchantedTotemChargeRecipe::new);
        RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableSpeedCharm")}), SpeedChargeRecipe.SERIALIZER, SpeedChargeRecipe::new);
        RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableWaterBreathingCharm")}), WaterBreathingChargeRecipe.SERIALIZER, WaterBreathingChargeRecipe::new);
    }
}

