/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration.jei;

import chargedcharms.ChargedCharms;
import chargedcharms.client.integration.CharmChargingRecipeMaker;
import chargedcharms.client.integration.jei.Recipes;
import chargedcharms.common.crafting.recipe.AbsorptionChargeRecipe;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.types.IRecipeType;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.common.Internal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeMap;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import technology.roughness.whitenoise.platform.Services;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocationHelper.prefix("jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        RecipeMap clientSyncedRecipes = Internal.getClientSyncedRecipes();
        if (clientSyncedRecipes.values().isEmpty()) {
            ChargedCharms.LOGGER.error("JEI Recipe Registration failed: No synced recipes");
            return;
        }
        Recipes recipes = new Recipes(clientSyncedRecipes);
        List<RecipeHolder<CraftingRecipe>> allCraftingRecipes = recipes.getCraftingRecipes();
        List<RecipeHolder<CraftingRecipe>> charmChargingRecipes = JEIPlugin.addChargingRecipes(allCraftingRecipes);
        registration.addRecipes((IRecipeType)RecipeTypes.CRAFTING, charmChargingRecipes);
        if (!Services.PLATFORM.isModLoaded("biomemakeover") || ConfigHandler.Common.disableEnchTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.enchantedTotemCharm)));
        }
        if (ConfigHandler.Common.disableRegenCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.regenerationCharm)));
        }
        if (ConfigHandler.Common.disableAbsorptionCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.absorptionCharm)));
        }
        if (ConfigHandler.Common.disableGlowupCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.glowupCharm)));
        }
        if (ConfigHandler.Common.disableTotemCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.totemCharm)));
        }
        if (ConfigHandler.Common.disableSpeedCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.speedCharm)));
        }
        if (ConfigHandler.Common.disableWaterBreathingCharm()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singleton(new ItemStack((ItemLike)ChargedCharmsItems.waterBreathingCharm)));
        }
    }

    private static List<RecipeHolder<CraftingRecipe>> addChargingRecipes(List<RecipeHolder<CraftingRecipe>> allCraftingRecipes) {
        IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>> replacers = new IdentityHashMap<Class<AbsorptionChargeRecipe>, Supplier<List>>();
        ArrayList recipes = new ArrayList();
        CharmChargingRecipeMaker.createRecipes("jei").forEach(pair -> recipes.add((RecipeHolder)pair.getSecond()));
        replacers.put(AbsorptionChargeRecipe.class, () -> recipes);
        return allCraftingRecipes.stream().map(RecipeHolder::value).map(CraftingRecipe::getClass).distinct().filter(replacers::containsKey).limit(replacers.size()).flatMap(recipeClass -> {
            Supplier supplier = (Supplier)replacers.get(recipeClass);
            try {
                List results = (List)supplier.get();
                return results.stream();
            }
            catch (RuntimeException e) {
                ChargedCharms.LOGGER.error("Failed to create JEI Recipes for {} {}", recipeClass, (Object)e);
                return Stream.of(new RecipeHolder[0]);
            }
        }).toList();
    }
}

