/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.integration.accessories;

import chargedcharms.ChargedCharms;
import chargedcharms.data.integration.accessories.SlotData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import technology.roughness.whitenoise.util.ResourceLocationHelper;

public class SlotDataProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final Map<ResourceLocation, SlotData> slotDataMap = new HashMap<ResourceLocation, SlotData>();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(SlotData.class, (Object)new SlotData.Serializer()).create();

    public SlotDataProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    protected void registerSlotData() {
        this.add(ChargedCharms.prefix("charged_charm"), new SlotData(false, 2, SlotData.Operation.SET, 1000, ResourceLocationHelper.loc((String)"accessories", (String)"container/slot/charm"), List.of(SlotData.Validator.TAG, SlotData.Validator.COMPONENT, SlotData.Validator.ATTRIBUTE)));
    }

    @NotNull
    public String getName() {
        return "Charged Charms - Accessories Slot Data";
    }

    protected void add(ResourceLocation id, SlotData slotData) {
        this.slotDataMap.put(id, slotData);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput cache) {
        ArrayList<CompletableFuture> outputs = new ArrayList<CompletableFuture>();
        this.registerSlotData();
        for (Map.Entry<ResourceLocation, SlotData> entry : this.slotDataMap.entrySet()) {
            Path path = this.getPathProvider(entry.getKey());
            outputs.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)GSON.toJsonTree((Object)entry.getValue()), (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])outputs.toArray(CompletableFuture[]::new));
    }

    private Path getPathProvider(ResourceLocation location) {
        return this.packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "accessories/slot").json(location);
    }
}

