/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.data.recipe;

import chargedcharms.common.crafting.recipe.AbsorptionChargeRecipe;
import chargedcharms.common.crafting.recipe.EnchantedTotemChargeRecipe;
import chargedcharms.common.crafting.recipe.RegenerationChargeRecipe;
import chargedcharms.common.crafting.recipe.SpeedChargeRecipe;
import chargedcharms.common.crafting.recipe.TotemChargeRecipe;
import chargedcharms.common.crafting.recipe.WaterBreathingChargeRecipe;
import chargedcharms.data.recipe.ConfigResourceCondition;
import chargedcharms.data.recipe.RecipeProviderBase;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;
import org.jetbrains.annotations.NotNull;

public class NeoForgeRecipeProvider
extends RecipeProvider.Runner {
    public NeoForgeRecipeProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "ChargedCharms.MOD_NAME - NeoForge Recipes";
    }

    @NotNull
    protected RecipeProvider createRecipeProvider(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, final @NotNull RecipeOutput recipeOutput) {
        return new VanillaRecipeProvider(this, provider, recipeOutput){

            public void buildRecipes() {
                HolderLookup.RegistryLookup itemRegistry = this.registries.lookupOrThrow(Registries.ITEM);
                RecipeOutput bmoWrapped = recipeOutput.withConditions(new ICondition[]{new ModLoadedCondition("biomemakeover"), new ConfigResourceCondition("disableEnchTotemCharm")});
                RecipeProviderBase.regenerationCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableRegenCharm")}));
                RecipeProviderBase.absorptionCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableAbsorptionCharm")}));
                RecipeProviderBase.glowupCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableGlowupCharm")}));
                RecipeProviderBase.totemCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableTotemCharm")}));
                RecipeProviderBase.enchantedTotemCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(bmoWrapped);
                RecipeProviderBase.speedCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableSpeedCharm")}));
                RecipeProviderBase.waterBreathingCharm((HolderLookup.RegistryLookup<Item>)itemRegistry).save(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableWaterBreathingCharm")}));
                RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableRegenCharm")}), (CustomRecipe.Serializer)RegenerationChargeRecipe.SERIALIZER, RegenerationChargeRecipe::new);
                RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableTotemCharm")}), (CustomRecipe.Serializer)TotemChargeRecipe.SERIALIZER, TotemChargeRecipe::new);
                RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableAbsorptionCharm")}), (CustomRecipe.Serializer)AbsorptionChargeRecipe.SERIALIZER, AbsorptionChargeRecipe::new);
                RecipeProviderBase.specialRecipe(bmoWrapped, (CustomRecipe.Serializer)EnchantedTotemChargeRecipe.SERIALIZER, EnchantedTotemChargeRecipe::new);
                RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableSpeedCharm")}), (CustomRecipe.Serializer)SpeedChargeRecipe.SERIALIZER, SpeedChargeRecipe::new);
                RecipeProviderBase.specialRecipe(recipeOutput.withConditions(new ICondition[]{new ConfigResourceCondition("disableWaterBreathingCharm")}), (CustomRecipe.Serializer)WaterBreathingChargeRecipe.SERIALIZER, WaterBreathingChargeRecipe::new);
            }
        };
    }
}

