/*
 * Decompiled with CFR 0.152.
 */
package icu.takeneko.mccr.networking;

import icu.takeneko.mccr.Mod;
import icu.takeneko.mccr.completion.CompletionResult;
import icu.takeneko.mccr.completion.CompletionService;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class PayloadedNetworking {
    private static final Long2ReferenceMap<CompletableFuture<CompletionResult>> futures = new Long2ReferenceLinkedOpenHashMap();
    private static final AtomicLong requestId = new AtomicLong();

    public static CompletableFuture<CompletionResult> requestCompletion(String content) {
        CompletableFuture<CompletionResult> future = new CompletableFuture<CompletionResult>();
        long id = requestId.addAndGet(1L);
        futures.put(id, future);
        ClientPlayNetworking.send((class_8710)new ServerboundRequestCompletionPacket(content, id));
        return future;
    }

    public record ServerboundRequestCompletionPacket(String content, long session) implements class_8710
    {
        public static final class_8710.class_9154<ServerboundRequestCompletionPacket> TYPE = new class_8710.class_9154(Mod.location("request_completion"));
        public static final class_9139<ByteBuf, ServerboundRequestCompletionPacket> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.field_48554, ServerboundRequestCompletionPacket::content, (class_9139)class_9135.field_48551, ServerboundRequestCompletionPacket::session, ServerboundRequestCompletionPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public void handle(ServerPlayNetworking.Context context) {
            CompletionService.requestCompletion(context.player(), this.content).thenAccept(it -> context.responseSender().sendPacket((class_8710)new ClientboundCompletionResultPacket(it.getCompletion(), it.getHint(), this.session)));
        }
    }

    public record ClientboundCompletionResultPacket(List<String> content, String hint, long session) implements class_8710
    {
        public static final class_8710.class_9154<ClientboundCompletionResultPacket> TYPE = new class_8710.class_9154(Mod.location("completion_result"));
        public static final class_9139<ByteBuf, ClientboundCompletionResultPacket> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.method_56376(ArrayList::new, (class_9139)class_9135.field_48554), ClientboundCompletionResultPacket::content, (class_9139)class_9135.field_48554, ClientboundCompletionResultPacket::hint, (class_9139)class_9135.field_48551, ClientboundCompletionResultPacket::session, ClientboundCompletionResultPacket::new);

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public void handle(ClientPlayNetworking.Context context) {
            CompletableFuture future = (CompletableFuture)futures.get(this.session);
            if (future != null) {
                future.complete(new CompletionResult(this.content, this.hint));
            }
        }
    }
}

