/*
 * Decompiled with CFR 0.152.
 */
package icu.takeneko.mccr.networking;

import icu.takeneko.mccr.Mod;
import icu.takeneko.mccr.completion.CompletionResult;
import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class LegacyNetworking {
    private static final Long2ReferenceMap<CompletableFuture<CompletionResult>> futures = new Long2ReferenceLinkedOpenHashMap();
    private static final AtomicLong requestId = new AtomicLong();

    public static CompletableFuture<CompletionResult> requestCompletion(String content) {
        CompletableFuture<CompletionResult> future = new CompletableFuture<CompletionResult>();
        long id = requestId.addAndGet(1L);
        futures.put(id, future);
        return future;
    }

    public static final class ClientboundCompletionResultPacket {
        public static final class_2960 ID = Mod.location("completion_result");
        private final List<String> content;
        private final String hint;
        private final long session;

        public ClientboundCompletionResultPacket(List<String> content, String hint, long session) {
            this.content = content;
            this.session = session;
            this.hint = hint;
        }

        public ClientboundCompletionResultPacket(class_2540 buf) {
            this.hint = buf.method_10800(Short.MAX_VALUE);
            int len = buf.method_10816();
            this.content = new ArrayList<String>();
            for (int i = 0; i < len; ++i) {
                this.content.add(buf.method_10800(Short.MAX_VALUE));
            }
            this.session = buf.method_10792();
        }

        public void handle() {
            CompletableFuture future = (CompletableFuture)futures.get(this.session);
            if (future != null) {
                future.complete(new CompletionResult(this.content, this.hint));
            }
        }

        public void encode(class_2540 buf) {
            buf.method_10814(this.hint);
            buf.method_10804(this.content.size());
            for (String s : this.content) {
                buf.method_10814(s);
            }
            buf.method_10791(this.session);
        }

        public List<String> content() {
            return this.content;
        }
    }

    public static final class ServerboundRequestCompletionPacket {
        public static final class_2960 ID = Mod.location("request_completion");
        private final String content;
        private final long session;

        public ServerboundRequestCompletionPacket(String content, long session) {
            this.content = content;
            this.session = session;
        }

        public ServerboundRequestCompletionPacket(class_2540 buf) {
            this.content = buf.method_10800(Short.MAX_VALUE);
            this.session = buf.method_10792();
        }

        public void handle(MinecraftServer server, class_3222 player, PacketSender sender) {
        }

        public void encode(class_2540 buf) {
            buf.method_10814(this.content);
            buf.method_10791(this.session);
        }

        public String content() {
            return this.content;
        }
    }
}

