/*
 * Decompiled with CFR 0.152.
 */
package icu.takeneko.mccr.completion.stdio;

import com.google.gson.Gson;
import icu.takeneko.mccr.completion.CompletionResult;
import icu.takeneko.mccr.completion.CompletionService;
import icu.takeneko.mccr.mixin.MixinPluginStealingOriginalStdout;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StdioCompletionServiceImpl
extends CompletionService {
    private static final Logger logger = LogManager.getLogger((String)"StdioCompletionServiceImpl");
    private final AtomicLong completionId = new AtomicLong(1L);
    private final Long2ObjectMap<CompletableFuture<CompletionResult>> futures = new Long2ObjectLinkedOpenHashMap();
    public static final Gson gson = new Gson();

    public StdioCompletionServiceImpl() {
        logger.info("Configured STDIO completion support.");
    }

    @Override
    public CompletableFuture<CompletionResult> accept(class_3222 player, String command) {
        CompletableFuture<CompletionResult> future = new CompletableFuture<CompletionResult>();
        long id = this.completionId.getAndAdd(1L);
        String message = "$$CompletionRequest$$%s$$CompletionRequest$$".formatted(gson.toJson((Object)new CompletionRequest(player.method_7334().getName(), command, id)));
        this.futures.put(id, future);
        MixinPluginStealingOriginalStdout.stdout.println(message);
        return future;
    }

    public void complete(long id, CompletionResult result) {
        CompletableFuture fut = (CompletableFuture)this.futures.get(id);
        if (fut == null) {
            return;
        }
        fut.complete(result);
    }

    class CompletionRequest {
        private final String playerName;
        private final String command;
        private final long id;

        CompletionRequest(String playerName, String command, long id) {
            this.playerName = playerName;
            this.command = command;
            this.id = id;
        }
    }
}

