/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import com.mojang.blaze3d.systems.RenderSystem;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.component.DataComponents;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmData;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmTierLevel;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;

public class MobFarmBlockItem
extends BlockItem {
    public static final String ID = "mob_farm_block_item";
    private final String farmName;
    private final MobFarmType mobFarmType;

    public MobFarmBlockItem(MobFarmType mobFarmType, Block block) {
        this(mobFarmType, block, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)mobFarmType.getId()))));
    }

    public MobFarmBlockItem(MobFarmType mobFarmType, Block block, Item.Properties properties) {
        super(block, properties);
        this.mobFarmType = mobFarmType;
        this.farmName = mobFarmType.getId();
    }

    public static MobFarmTierLevel getTierLevel(ItemStack itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        return mobFarmData.tierLevel();
    }

    public String getFarmName() {
        return this.farmName;
    }

    public MobFarmType getMobFarmType() {
        return this.mobFarmType;
    }

    public Component getName(ItemStack itemStack) {
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        return TextComponent.getTranslatedBlockText(this.farmName, tierLevel);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        MutableComponent processingSpeedText;
        MutableComponent tierLevelText;
        super.appendHoverText(itemStack, tooltipContext, tooltipDisplay, tooltipConsumer, tooltipFlag);
        MutableComponent farmDescription = TextComponent.getTranslatedText(this.farmName);
        if (RenderSystem.isOnRenderThread()) {
            List lines = Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)farmDescription, 200, Style.EMPTY);
            for (FormattedText line : lines) {
                tooltipConsumer.accept((Component)Component.literal((String)line.getString()).withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipConsumer.accept((Component)farmDescription.copy().withStyle(ChatFormatting.GRAY));
        }
        MobFarmData mobFarmData = (MobFarmData)itemStack.getOrDefault(DataComponents.MOB_FARM_DATA, (Object)MobFarmData.EMPTY);
        int tierLevel = mobFarmData.tierLevel().getTierLevel();
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level", tierLevel, ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = tierLevelText = null;
            }
        }
        if (tierLevelText != null) {
            tooltipConsumer.accept((Component)tierLevelText);
        }
        switch (tierLevel) {
            case 0: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.WHITE);
                break;
            }
            case 1: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.GREEN);
                break;
            }
            case 2: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.YELLOW);
                break;
            }
            case 3: {
                MutableComponent mutableComponent = TextComponent.getTranslatedText("tier_level_processing_speed", MobFarmBlockEntity.getProcessingSpeed(tierLevel), ChatFormatting.RED);
                break;
            }
            default: {
                MutableComponent mutableComponent = processingSpeedText = null;
            }
        }
        if (processingSpeedText != null) {
            tooltipConsumer.accept((Component)processingSpeedText);
        }
        if (MobFarmType.LUCKY_DROP_FARM.getId().equals(this.farmName)) {
            tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_percentage", new Object[]{MobFarmConfig.luckyDropFarmLuckPercentage}));
            if (MobFarmConfig.luckyDropFarmLuckPercentage < 100) {
                tooltipConsumer.accept((Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.farm.lucky_drop_warn").withStyle(ChatFormatting.RED));
            }
        }
    }
}

