/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Block;

public class MobFarmTemplateItem
extends BlockItem {
    public static final String ID_TIER_0 = "tier0_mob_farm_template";
    public static final String ID_TIER_1 = "tier1_mob_farm_template";
    public static final String ID_TIER_2 = "tier2_mob_farm_template";
    public static final String ID_TIER_3 = "tier3_mob_farm_template";
    private final String tierLevel;

    public MobFarmTemplateItem(String tierLevel, Block block) {
        Item.Properties properties = new Item.Properties().useBlockDescriptionPrefix();
        this(tierLevel, block, properties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_mob_farm", (String)(switch (tierLevel) {
            case ID_TIER_1 -> ID_TIER_1;
            case ID_TIER_2 -> ID_TIER_2;
            case ID_TIER_3 -> ID_TIER_3;
            default -> ID_TIER_0;
        })))));
    }

    public MobFarmTemplateItem(String tierLevel, Block block, Item.Properties properties) {
        super(block, properties);
        this.tierLevel = tierLevel;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipConsumer, TooltipFlag tooltipFlag) {
        tooltipConsumer.accept((Component)TextComponent.getTranslatedText("mob_farm_template").withStyle(ChatFormatting.YELLOW));
        MutableComponent tierLevelText = switch (this.tierLevel) {
            case ID_TIER_1 -> TextComponent.getTranslatedText("tier_level", 1, ChatFormatting.GREEN);
            case ID_TIER_2 -> TextComponent.getTranslatedText("tier_level", 2, ChatFormatting.YELLOW);
            case ID_TIER_3 -> TextComponent.getTranslatedText("tier_level", 3, ChatFormatting.RED);
            default -> TextComponent.getTranslatedText("tier_level", 0, ChatFormatting.WHITE);
        };
        tooltipConsumer.accept((Component)tierLevelText);
    }
}

