/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import de.markusbordihn.easymobfarm.item.mobcatcher.MobCatcherItem;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class MobCaptureDataSupport {
    public static final String CREATE_BLAZE_BURNER = "create:blaze_burner";
    public static final String MOB_CATCHER_DIAMOND = "mob_catcher:diamond_mob_catcher";
    public static final String MOB_CATCHER_NETHERITE = "mob_catcher:netherite_mob_catcher";
    public static final String MOB_CAPTURING_TOOL = "mobcapturingtool:mob_capturing_tool";
    public static final String SUPPLEMENTARIES_CAGE = "supplementaries:cage";
    public static final String SUPPLEMENTARIES_JAR = "supplementaries:jar";
    public static final String PRODUCTIVE_BEES_BEE_CAGE = "productivebees:bee_cage";
    public static final String PRODUCTIVE_BEES_BEE_JAR = "productivebees:bee_jar";
    private static final String MOD_DATA_TAG = "mob_data";
    private static final String ID_TAG = "id";
    private static final String CAPTURED_ENTITY_TAG = "CapturedEntity";
    private static final String ENTITY_TYPE_TAG = "EntityType";
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";
    private static final String MOB_HOLDER_TAG = "MobHolder";
    private static final String ENTITY_DATA_TAG = "EntityData";
    private static final String ENTITY_TAG = "Entity";
    private static final String ENTITY__TAG = "Entity".toLowerCase(Locale.ROOT);

    public static boolean isSupported(ItemStack itemStack) {
        if (!MobCaptureDataSupport.isValidItemStack(itemStack)) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof MobCaptureCardItem || item instanceof SpawnEggItem || item instanceof MobCatcherItem) {
            return true;
        }
        String itemRegistryName = MobCaptureDataSupport.getItemRegistryName(item);
        if (itemRegistryName.isEmpty()) {
            return false;
        }
        return CREATE_BLAZE_BURNER.equals(itemRegistryName) || MOB_CATCHER_DIAMOND.equals(itemRegistryName) || MOB_CATCHER_NETHERITE.equals(itemRegistryName) || MOB_CAPTURING_TOOL.equals(itemRegistryName) || SUPPLEMENTARIES_CAGE.equals(itemRegistryName) || SUPPLEMENTARIES_JAR.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_CAGE.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_JAR.equals(itemRegistryName);
    }

    public static EntityType<?> getEntityType(ItemStack itemStack, Level level) {
        String itemRegistryName;
        if (!MobCaptureDataSupport.isValidItemStack(itemStack)) {
            return null;
        }
        Item item = itemStack.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem spawnEggItem = (SpawnEggItem)item;
            if (level != null) {
                return spawnEggItem.getType(itemStack);
            }
        }
        if (CREATE_BLAZE_BURNER.equals(itemRegistryName = MobCaptureDataSupport.getItemRegistryName(item))) {
            return EntityType.BLAZE;
        }
        CompoundTag compoundTag = ((CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if ((MOB_CATCHER_DIAMOND.equals(itemRegistryName) || MOB_CATCHER_NETHERITE.equals(itemRegistryName)) && compoundTag.contains(MOD_DATA_TAG) && compoundTag.getCompound(MOD_DATA_TAG).isPresent() && ((CompoundTag)compoundTag.getCompound(MOD_DATA_TAG).get()).contains(ID_TAG) && ((CompoundTag)compoundTag.getCompound(MOD_DATA_TAG).get()).getString(ID_TAG).isPresent()) {
            return MobCaptureDataSupport.getEntityType((String)((CompoundTag)compoundTag.getCompound(MOD_DATA_TAG).get()).getString(ID_TAG).get());
        }
        if (MOB_CAPTURING_TOOL.equals(itemRegistryName) && compoundTag.contains(CAPTURED_ENTITY_TAG) && compoundTag.getCompound(CAPTURED_ENTITY_TAG).isPresent() && ((CompoundTag)compoundTag.getCompound(CAPTURED_ENTITY_TAG).get()).contains(ENTITY_TYPE_TAG) && ((CompoundTag)compoundTag.getCompound(CAPTURED_ENTITY_TAG).get()).getString(ENTITY_TYPE_TAG).isPresent()) {
            return MobCaptureDataSupport.getEntityType((String)((CompoundTag)compoundTag.getCompound(CAPTURED_ENTITY_TAG).get()).getString(ENTITY_TYPE_TAG).get());
        }
        if ((SUPPLEMENTARIES_CAGE.equals(itemRegistryName) || SUPPLEMENTARIES_JAR.equals(itemRegistryName)) && compoundTag.contains(BLOCK_ENTITY_TAG) && compoundTag.getCompound(BLOCK_ENTITY_TAG).isPresent() && ((CompoundTag)compoundTag.getCompound(BLOCK_ENTITY_TAG).get()).contains(MOB_HOLDER_TAG) && ((CompoundTag)compoundTag.getCompound(BLOCK_ENTITY_TAG).get()).getCompound(MOB_HOLDER_TAG).isPresent() && ((CompoundTag)((CompoundTag)compoundTag.getCompound(BLOCK_ENTITY_TAG).get()).getCompound(MOB_HOLDER_TAG).get()).contains(ENTITY_DATA_TAG) && ((CompoundTag)((CompoundTag)compoundTag.getCompound(BLOCK_ENTITY_TAG).get()).getCompound(MOB_HOLDER_TAG).get()).getCompound(ENTITY_DATA_TAG).isPresent()) {
            return MobCaptureDataSupport.getEntityType((String)((CompoundTag)((CompoundTag)((CompoundTag)compoundTag.getCompound(BLOCK_ENTITY_TAG).get()).getCompound(MOB_HOLDER_TAG).get()).getCompound(ENTITY_DATA_TAG).get()).getString(ID_TAG).get());
        }
        if ((PRODUCTIVE_BEES_BEE_CAGE.equals(itemRegistryName) || PRODUCTIVE_BEES_BEE_JAR.equals(itemRegistryName)) && compoundTag.contains(ENTITY__TAG) && compoundTag.getString(ENTITY__TAG).isPresent()) {
            return MobCaptureDataSupport.getEntityType((String)compoundTag.getString(ENTITY__TAG).get());
        }
        return null;
    }

    public static EntityType<?> getEntityType(String entityName) {
        if (entityName == null || entityName.isEmpty()) {
            return null;
        }
        Optional entityTypeHolder = BuiltInRegistries.ENTITY_TYPE.getOptional(ResourceLocation.parse((String)entityName));
        return entityTypeHolder.orElse(null);
    }

    public static String getEntityTypeName(ItemStack itemStack, Level level) {
        EntityType<?> entityType = MobCaptureDataSupport.getEntityType(itemStack, level);
        if (entityType != null) {
            return BuiltInRegistries.ENTITY_TYPE.getKey(entityType).toString();
        }
        return "";
    }

    public static String getItemRegistryName(Item item) {
        if (item == null) {
            return "";
        }
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    private static boolean isValidItemStack(ItemStack itemStack) {
        return itemStack != null && !itemStack.isEmpty() && itemStack.getCount() == 1;
    }
}

