/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.tabs;

import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.data.capture.MobColor;
import de.markusbordihn.easymobfarm.item.mobcapturecard.MobCaptureCardItem;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CustomMobCaptureCards {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    private CustomMobCaptureCards() {
    }

    public static Set<ItemStack> getCustomMobCaptureCards(ItemLike mobCaptureCardItem) {
        if (!(mobCaptureCardItem instanceof MobCaptureCardItem)) {
            return Collections.emptySet();
        }
        LinkedHashSet<ItemStack> result = new LinkedHashSet<ItemStack>();
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Common Card", EntityType.ARMOR_STAND, Rarity.COMMON)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Uncommon Card", EntityType.ARMOR_STAND, Rarity.UNCOMMON)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Rare Card", EntityType.ARMOR_STAND, Rarity.RARE)));
        result.add(MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, new MobCaptureData("Epic Card", EntityType.ARMOR_STAND, Rarity.EPIC)));
        MobCaptureCardDefinitionManager.getAll().forEach((location, definition) -> {
            if (definition == null || definition.entityType() == null || definition.model() == null) {
                return;
            }
            ItemStack itemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType());
            if (itemStack != null && !itemStack.isEmpty()) {
                result.add(itemStack);
            }
            definition.variants().forEach((variantName, variant) -> {
                if (variant == null) {
                    return;
                }
                ItemStack variantItemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType(), variantName, null);
                if (variantItemStack != null && !variantItemStack.isEmpty()) {
                    result.add(variantItemStack);
                }
            });
            definition.colors().forEach((colorName, color) -> {
                if (color == null) {
                    return;
                }
                ItemStack colorItemStack = MobCaptureManager.createMobCaptureCard(mobCaptureCardItem, definition.entityType(), null, MobColor.valueOf(colorName.toUpperCase(Locale.ROOT)));
                if (colorItemStack != null && !colorItemStack.isEmpty()) {
                    result.add(colorItemStack);
                }
            });
        });
        return result;
    }
}

