/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.manager;

import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.monster.ElderGuardian;

public class EntityScalingManager {
    private static final float MAX_BLOCK_SCALE = 0.8f;
    private static final float DEFAULT_SCALE_BLOCK = 0.3f;
    private static final Map<Class<? extends Entity>, Float> entityScaleCache = new HashMap<Class<? extends Entity>, Float>();

    private EntityScalingManager() {
    }

    public static float getEntityScale(Entity entity) {
        return entityScaleCache.computeIfAbsent(entity.getClass(), cls -> {
            float entityHeight;
            float entityWidth;
            if (entity.m_142469_().m_82362_() > 0.0 && entity.m_142469_().m_82376_() > 0.0) {
                entityWidth = (float)entity.m_142469_().m_82362_();
                entityHeight = (float)entity.m_142469_().m_82376_();
            } else {
                entityWidth = entity.m_6972_((Pose)entity.m_20089_()).f_20377_;
                entityHeight = entity.m_6972_((Pose)entity.m_20089_()).f_20378_;
            }
            MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.m_6095_());
            if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.scale() > 0.0f && mobCaptureCardDefinition.scale() != 1.0f) {
                entityWidth *= mobCaptureCardDefinition.scale();
                entityHeight *= mobCaptureCardDefinition.scale();
            }
            if (entityWidth == 0.0f || entityHeight == 0.0f) {
                return Float.valueOf(0.3f);
            }
            if (entity instanceof ElderGuardian) {
                entityWidth *= 1.8f;
            }
            if (entityWidth < 0.8f && entityHeight < 0.8f || entityWidth * 0.3f < 0.8f && entityHeight * 0.3f < 0.8f) {
                return Float.valueOf(0.3f);
            }
            float scaleFactor = Math.max(entityWidth, entityHeight) / 0.8f;
            if (scaleFactor > 1.0f) {
                FlyingAnimal flyingAnimal;
                if (entity instanceof FlyingMob || entity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)entity).m_142592_()) {
                    return Float.valueOf(0.8f / scaleFactor * 0.6f);
                }
                return Float.valueOf(0.8f / scaleFactor);
            }
            return Float.valueOf(0.8f);
        }).floatValue();
    }

    public static float getUIScale(Entity entity) {
        float entityScale = EntityScalingManager.getEntityScale(entity);
        return entityScale * 45.0f;
    }
}

