/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Rarity;

public record MobCaptureCardDefinition(ResourceLocation entity, EntityType<?> entityType, ResourceLocation model, Rarity rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
    public MobCaptureCardDefinition(ResourceLocation entity, ResourceLocation model, Rarity rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
        this(entity, MobCaptureCardDefinition.getEntityType(entity), MobCaptureCardDefinition.getModelResourceLocation(model, rarity != null ? rarity : Rarity.COMMON), rarity != null ? rarity : Rarity.COMMON, scale >= 0.0f ? scale : 1.0f, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static MobCaptureCardDefinition decode(FriendlyByteBuf buffer) {
        ResourceLocation entity = buffer.m_130281_();
        ResourceLocation model = buffer.m_130281_();
        Rarity rarity = (Rarity)buffer.m_130066_(Rarity.class);
        float scale = buffer.readFloat();
        boolean requiresKilledByPlayer = buffer.readBoolean();
        boolean requiresAnimationTick = buffer.readBoolean();
        Map colors = buffer.m_178368_(FriendlyByteBuf::m_130277_, buf -> new Color(buf.m_130281_()));
        Map variants = buffer.m_178368_(FriendlyByteBuf::m_130277_, buf -> {
            ResourceLocation variantModel = buf.m_130281_();
            Map variantColors = buf.m_178368_(FriendlyByteBuf::m_130277_, b -> new Color(b.m_130281_()));
            return new Variant(variantModel, variantColors);
        });
        return new MobCaptureCardDefinition(entity, model, rarity, scale, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static EntityType<?> getEntityType(ResourceLocation resourceLocation) {
        return EntityType.m_20632_((String)resourceLocation.toString()).orElse(null);
    }

    public static ResourceLocation getModelResourceLocation(ResourceLocation resourceLocation, Rarity rarity) {
        if (resourceLocation != null) {
            return resourceLocation;
        }
        switch (rarity) {
            case UNCOMMON: {
                return new ResourceLocation("easy_mob_farm", "item/mob_capture_card/default_uncommon");
            }
            case RARE: {
                return new ResourceLocation("easy_mob_farm", "item/mob_capture_card/default_rare");
            }
            case EPIC: {
                return new ResourceLocation("easy_mob_farm", "item/mob_capture_card/default_epic");
            }
        }
        return new ResourceLocation("easy_mob_farm", "item/mob_capture_card/default");
    }

    public MobCaptureCardDefinition withEntityType(EntityType<?> entityType) {
        return new MobCaptureCardDefinition(this.entity, entityType, this.model, this.rarity, this.scale, this.requiresKilledByPlayer, this.requiresAnimationTick, this.variants, this.colors);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.entity);
        buffer.m_130085_(this.model);
        buffer.m_130068_((Enum)this.rarity);
        buffer.writeFloat(this.scale);
        buffer.writeBoolean(this.requiresKilledByPlayer);
        buffer.writeBoolean(this.requiresAnimationTick);
        buffer.m_178355_(this.colors, FriendlyByteBuf::m_130070_, (buf, color) -> buf.m_130085_(color.model()));
        buffer.m_178355_(this.variants, FriendlyByteBuf::m_130070_, (buf, variant) -> {
            buf.m_130085_(variant.model());
            buf.m_178355_(variant.colors(), FriendlyByteBuf::m_130070_, (b, color) -> b.m_130085_(color.model()));
        });
    }

    public record Variant(ResourceLocation model, Map<String, Color> colors) {
    }

    public record Color(ResourceLocation model) {
    }
}

