/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobColorData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityTypeData;
import de.markusbordihn.easymobfarm.data.capture.MobFoilData;
import de.markusbordihn.easymobfarm.data.capture.MobNameData;
import de.markusbordihn.easymobfarm.data.capture.MobRarityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public record MobCaptureData(String name, String type, EntityType<?> entityType, CompoundTag data, DyeColor color, String variant, Rarity rarity, boolean isFoil) {
    private static final int MAX_ID_LIMIT = 0x1000000;

    public MobCaptureData(String name, EntityType<?> entityType, Rarity rarity) {
        this(name, MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), rarity, MobFoilData.getRandomFoil());
    }

    public MobCaptureData(EntityType<?> entityType) {
        this(MobNameData.getName(entityType), MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), MobRarityData.getRarity(entityType), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(LivingEntity livingEntity) {
        this(MobNameData.getName(livingEntity), MobEntityTypeData.getEntityTypeName(livingEntity), MobEntityTypeData.getEntityType(livingEntity), MobEntityData.getMobEntityData(livingEntity), MobColorData.getColor(livingEntity), MobVariantData.getVariant(livingEntity), MobRarityData.getRarity(livingEntity), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(ItemStack itemStack, CompoundTag compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag), MobEntityTypeData.getEntityType(itemStack, compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(CompoundTag compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(compoundTag), MobEntityTypeData.getEntityType(compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public int getCardId() {
        int namespaceHash = 0;
        int pathHash = 0;
        if (this.type != null) {
            String[] parts = this.type.split(":");
            if (parts.length > 0) {
                namespaceHash = parts[0].hashCode();
            }
            if (parts.length > 1) {
                pathHash = parts[1].hashCode();
            }
        }
        int colorHash = this.color != null ? this.color.hashCode() : 0;
        int variantHash = this.variant != null ? this.variant.hashCode() : 0;
        int result = 17;
        result = 31 * result + namespaceHash;
        result = 31 * result + pathHash;
        result = 31 * result + colorHash;
        result = 31 * result + variantHash;
        result = 31 * result + (this.isFoil ? 1 : 0);
        result ^= result >>> 16;
        return (result & Integer.MAX_VALUE) % 0x1000000;
    }

    public MobCaptureData withColor(DyeColor color) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, color, this.variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withVariant(String variant) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withRarity(Rarity rarity) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, rarity, this.isFoil);
    }

    public MobCaptureData withFoil(boolean isFoil) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, this.rarity, isFoil);
    }

    public MobCaptureData withData(CompoundTag data) {
        return new MobCaptureData(this.name, this.type, this.entityType, data, this.color, this.variant, this.rarity, this.isFoil);
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public boolean hasData() {
        return this.data != null && !this.data.m_128456_();
    }

    public boolean hasVariant() {
        return this.variant != null && !this.variant.isEmpty();
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public CompoundTag write(CompoundTag compoundTag) {
        compoundTag.m_128359_("Name", this.name);
        compoundTag.m_128359_("Type", Registry.f_122826_.m_7981_(this.entityType).toString());
        compoundTag.m_128365_("Data", (Tag)this.data);
        if (this.hasColor()) {
            compoundTag.m_128359_("Color", this.color.m_41065_());
        }
        if (this.hasVariant()) {
            compoundTag.m_128359_("Variant", this.variant);
        }
        compoundTag.m_128359_("Rarity", this.rarity.name());
        compoundTag.m_128379_("Foil", this.isFoil);
        return compoundTag;
    }

    public CompoundTag createTag() {
        return this.write(new CompoundTag());
    }

    @Override
    public String toString() {
        return "MobCaptureData{, name='" + this.name + ", entityType=" + String.valueOf(this.entityType) + ", color=" + String.valueOf(this.color) + ", variant=" + this.variant + ", rarity=" + String.valueOf(this.rarity) + ", isFoil=" + this.isFoil + ", data=" + String.valueOf(this.data) + "}";
    }
}

