/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item;

import de.markusbordihn.easymobfarm.config.MobCatcherConfig;
import de.markusbordihn.easymobfarm.config.MobFarmConfig;
import java.util.Collection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.crafting.Recipe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRecipeManager {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final String LOG_PREFIX = "[Recipe Manager]";
    private static final String MOB_CAPTURE_PREFIX = "mob_catcher/";
    private static final String MOB_FARM_TEMPLATE_PREFIX = "mob_farm_template/";

    private ModRecipeManager() {
    }

    public static void register(MinecraftServer minecraftServer) {
        log.info("{} Mod Recipe Manager ...", (Object)"Register Easy Mob Farm");
        Collection recipes = minecraftServer.m_129894_().m_44051_();
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.ENDURING_CAPTURE_NET_ENABLED, "enduring_capture_net", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.IRONBOUND_CONTAINMENT_CAGE_ENABLED, "ironbound_containment_cage", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.MYSTIC_BINDING_CRYSTAL_ENABLED, "mystic_binding_crystal", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, MobCatcherConfig.VOID_BINDING_CHAIN_ENABLED, "void_binding_chain", MOB_CAPTURE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier1_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier2_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        ModRecipeManager.removeRecipeIfDisabled(recipes, !MobFarmConfig.enforceLogicalTierProgression, "tier3_mob_farm_template", MOB_FARM_TEMPLATE_PREFIX);
        if (minecraftServer.m_129894_().m_44051_().size() != recipes.size()) {
            log.info("Updating recipes with adjusted recipes ...");
            minecraftServer.m_129894_().m_44024_((Iterable)recipes);
            for (ServerPlayer player : minecraftServer.m_6846_().m_11314_()) {
                log.info("{} Sync recipe to player {} ...", (Object)LOG_PREFIX, (Object)player.m_7755_().getString());
                player.f_8906_.m_141995_((Packet)new ClientboundUpdateRecipesPacket(minecraftServer.m_129894_().m_44051_()));
            }
            minecraftServer.m_129894_().m_44051_().forEach(recipe -> log.debug("{} Loaded recipe: {}", (Object)LOG_PREFIX, (Object)recipe.m_6423_()));
        }
    }

    private static boolean removeRecipeIfDisabled(Collection<Recipe<?>> recipes, boolean isEnabled, String itemId, String recipePrefix) {
        if (isEnabled) {
            return false;
        }
        String recipePath = recipePrefix + itemId;
        boolean removed = recipes.removeIf(recipe -> recipe.m_6423_().m_135827_().equals("easy_mob_farm") && recipe.m_6423_().m_135815_().equals(recipePath));
        if (removed) {
            log.info("{} Removed {} recipe ...", (Object)LOG_PREFIX, (Object)recipePath);
        } else {
            log.error("{} Failed to deactivate recipe {} !", (Object)LOG_PREFIX, (Object)recipePath);
        }
        return removed;
    }
}

