/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.item.mobcatcher;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.capture.MobCaptureManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureData;
import de.markusbordihn.easymobfarm.item.MobFarmItem;
import de.markusbordihn.easymobfarm.network.components.TextComponent;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MobCatcherItem
extends MobFarmItem {
    public static final String ID = "mob_catcher";
    public static final String MOB_CAPTURE_DATA_TAG = "MobCaptureData";
    public static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    public static final String TOOLTIP_PREFIX = "tooltip.easy_mob_farm.mob_catcher.";
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");
    private static final float REQUIRED_HEALTH_PERCENTAGE_TO_CAPTURE = 0.25f;
    private static final float MAX_ENTITY_HEIGHT_TO_CAPTURE = 2.0f;
    private static final float MAX_ENTITY_WIDTH_TO_CAPTURE = 1.5f;
    private static final int ITEM_DAMAGE_ON_USE = 1;
    private static final Set<String> allowList = Set.of();
    private static final Set<String> denyList = Set.of();

    public MobCatcherItem(Item.Properties properties) {
        super(properties);
    }

    public boolean hasMobCaptureData(ItemStack itemStack) {
        return itemStack != null && itemStack.m_41782_() && itemStack.m_41783_() != null && itemStack.m_41783_().m_128441_(MOB_CAPTURE_DATA_TAG);
    }

    public float getRequiredHealthPercentageToCapture() {
        return 0.25f;
    }

    public float getMaxEntityHeightToCapture() {
        return 2.0f;
    }

    public float getMaxEntityWidthToCapture() {
        return 1.5f;
    }

    public int getItemDamageOnUse() {
        return 1;
    }

    public Set<String> getAllowList() {
        return allowList;
    }

    public Set<String> getDenyList() {
        return denyList;
    }

    public boolean m_5812_(ItemStack itemStack) {
        return this.hasMobCaptureData(itemStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        MobFarmBlockEntity mobFarmBlockEntity;
        BlockEntity blockEntity;
        Level level = context.m_43725_();
        BlockPos blockPos = context.m_8083_();
        ItemStack itemStack = context.m_43722_();
        if (!this.hasMobCaptureData(itemStack)) {
            return InteractionResult.FAIL;
        }
        if (level.m_8055_(blockPos).m_60734_() instanceof MobFarmBlock && (blockEntity = level.m_7702_(blockPos)) instanceof MobFarmBlockEntity && !(mobFarmBlockEntity = (MobFarmBlockEntity)blockEntity).hasCapturedMob()) {
            return InteractionResult.PASS;
        }
        if (!level.f_46443_ && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MobCaptureData mobCaptureData = new MobCaptureData(itemStack.m_41783_().m_128469_(MOB_CAPTURE_DATA_TAG));
            if (MobCaptureManager.releaseMob(mobCaptureData, blockPos, serverLevel)) {
                itemStack.m_41783_().m_128473_(MOB_CAPTURE_DATA_TAG);
                itemStack.m_41784_().m_128405_(CUSTOM_MODEL_DATA_TAG, 0);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6880_(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand hand) {
        float healthPercentage;
        if (livingEntity == null || livingEntity instanceof Player || livingEntity.m_21224_()) {
            return InteractionResult.FAIL;
        }
        if (this.hasMobCaptureData(itemStack)) {
            return InteractionResult.FAIL;
        }
        if (this.getItemDamageOnUse() > 0) {
            itemStack.m_41622_(this.getItemDamageOnUse(), (LivingEntity)player, playerEntity -> playerEntity.m_21190_(hand));
        }
        String entityName = Registry.f_122826_.m_7981_((Object)livingEntity.m_6095_()).toString();
        if (!this.getAllowList().isEmpty()) {
            if (!this.getAllowList().contains(entityName)) {
                log.debug("Mob {} is not on the allow list for {}.", (Object)entityName, (Object)this);
                player.m_5661_((Component)TextComponent.getTranslatedText("mob_is_not_on_allow_list", livingEntity.m_5446_().getString()), true);
                return InteractionResult.FAIL;
            }
        } else {
            if (!this.getDenyList().isEmpty() && this.getDenyList().contains(entityName)) {
                log.debug("Mob {} is on the deny list for {}.", (Object)entityName, (Object)this);
                player.m_5661_((Component)TextComponent.getTranslatedText("mob_is_on_deny_list", livingEntity.m_5446_().getString()), true);
                return InteractionResult.FAIL;
            }
            if (this.getMaxEntityHeightToCapture() > 0.0f || this.getMaxEntityWidthToCapture() > 0.0f) {
                EntityDimensions dimensions = livingEntity.m_6972_(livingEntity.m_20089_());
                if (dimensions.f_20378_ > this.getMaxEntityHeightToCapture() || dimensions.f_20377_ > this.getMaxEntityWidthToCapture()) {
                    log.debug("Mob {} with {}x{} size is too large to be captured by {}.", (Object)entityName, (Object)Float.valueOf(dimensions.f_20377_), (Object)Float.valueOf(dimensions.f_20378_), (Object)this);
                    player.m_5661_((Component)TextComponent.getTranslatedText("too_large_to_capture", livingEntity.m_5446_().getString()), true);
                    return InteractionResult.FAIL;
                }
            }
        }
        if (this.getRequiredHealthPercentageToCapture() > 0.0f && (healthPercentage = livingEntity.m_21223_() / livingEntity.m_21233_()) > this.getRequiredHealthPercentageToCapture()) {
            log.debug("Mob {} with {} health is too strong to be captured by {}.", (Object)entityName, (Object)Float.valueOf(healthPercentage), (Object)this);
            player.m_5661_((Component)TextComponent.getTranslatedText("too_strong_to_capture", livingEntity.m_5446_().getString()), true);
            return InteractionResult.FAIL;
        }
        Level level = livingEntity.m_183503_();
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MobCaptureData mobCaptureData = new MobCaptureData(livingEntity);
        itemStack.m_41784_().m_128365_(MOB_CAPTURE_DATA_TAG, (Tag)mobCaptureData.createTag());
        itemStack.m_41784_().m_128405_(CUSTOM_MODEL_DATA_TAG, 1);
        player.m_21008_(hand, itemStack);
        livingEntity.m_146870_();
        player.m_5661_((Component)TextComponent.getTranslatedText("captured_mob", mobCaptureData.name(), mobCaptureData.type()), true);
        return InteractionResult.CONSUME;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag flag) {
        if (this.hasMobCaptureData(itemStack)) {
            MobCaptureData mobCaptureData = MobCaptureManager.getMobCaptureData(itemStack);
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.release_hint", mobCaptureData.name()).m_130940_(ChatFormatting.DARK_RED));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.name", mobCaptureData.name()));
            if (flag.m_7050_()) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.type", mobCaptureData.type()));
            }
            if (mobCaptureData.variant() != null) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.variant", mobCaptureData.variant()));
            }
            if (mobCaptureData.color() != null) {
                this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.color", mobCaptureData.color().m_41065_()));
            }
        } else {
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.capture_hint").m_130940_(ChatFormatting.DARK_GREEN));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.max_size", this.getMaxEntityWidthToCapture() + "x" + this.getMaxEntityHeightToCapture()));
            this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.min_health", this.getRequiredHealthPercentageToCapture() * 100.0f + "%"));
        }
        this.addTooltip(tooltip, (Component)TextComponent.getTranslatedTextRaw("tooltip.easy_mob_farm.mob_catcher.usage_left", "(" + (itemStack.m_41776_() - itemStack.m_41773_()) + "/" + itemStack.m_41776_() + ")").m_130940_(ChatFormatting.GRAY));
    }
}

