/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1814;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public record MobCaptureCardDefinition(class_2960 entity, class_1299<?> entityType, class_2960 model, class_1814 rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
    public MobCaptureCardDefinition(class_2960 entity, class_2960 model, class_1814 rarity, float scale, boolean requiresKilledByPlayer, boolean requiresAnimationTick, Map<String, Variant> variants, Map<String, Color> colors) {
        this(entity, MobCaptureCardDefinition.getEntityType(entity), MobCaptureCardDefinition.getModelResourceLocation(model, rarity != null ? rarity : class_1814.field_8906), rarity != null ? rarity : class_1814.field_8906, scale >= 0.0f ? scale : 1.0f, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static MobCaptureCardDefinition decode(class_2540 buffer) {
        class_2960 entity = buffer.method_10810();
        class_2960 model = buffer.method_10810();
        class_1814 rarity = (class_1814)buffer.method_10818(class_1814.class);
        float scale = buffer.readFloat();
        boolean requiresKilledByPlayer = buffer.readBoolean();
        boolean requiresAnimationTick = buffer.readBoolean();
        Map colors = buffer.method_34067(class_2540::method_19772, buf -> new Color(buf.method_10810()));
        Map variants = buffer.method_34067(class_2540::method_19772, buf -> {
            class_2960 variantModel = buf.method_10810();
            Map variantColors = buf.method_34067(class_2540::method_19772, b -> new Color(b.method_10810()));
            return new Variant(variantModel, variantColors);
        });
        return new MobCaptureCardDefinition(entity, model, rarity, scale, requiresKilledByPlayer, requiresAnimationTick, variants, colors);
    }

    public static class_1299<?> getEntityType(class_2960 resourceLocation) {
        return class_1299.method_5898((String)resourceLocation.toString()).orElse(null);
    }

    public static class_2960 getModelResourceLocation(class_2960 resourceLocation, class_1814 rarity) {
        if (resourceLocation != null) {
            return resourceLocation;
        }
        switch (rarity) {
            case field_8907: {
                return new class_2960("easy_mob_farm", "item/mob_capture_card/default_uncommon");
            }
            case field_8903: {
                return new class_2960("easy_mob_farm", "item/mob_capture_card/default_rare");
            }
            case field_8904: {
                return new class_2960("easy_mob_farm", "item/mob_capture_card/default_epic");
            }
        }
        return new class_2960("easy_mob_farm", "item/mob_capture_card/default");
    }

    public MobCaptureCardDefinition withEntityType(class_1299<?> entityType) {
        return new MobCaptureCardDefinition(this.entity, entityType, this.model, this.rarity, this.scale, this.requiresKilledByPlayer, this.requiresAnimationTick, this.variants, this.colors);
    }

    public void encode(class_2540 buffer) {
        buffer.method_10812(this.entity);
        buffer.method_10812(this.model);
        buffer.method_10817((Enum)this.rarity);
        buffer.writeFloat(this.scale);
        buffer.writeBoolean(this.requiresKilledByPlayer);
        buffer.writeBoolean(this.requiresAnimationTick);
        buffer.method_34063(this.colors, class_2540::method_10814, (buf, color) -> buf.method_10812(color.model()));
        buffer.method_34063(this.variants, class_2540::method_10814, (buf, variant) -> {
            buf.method_10812(variant.model());
            buf.method_34063(variant.colors(), class_2540::method_10814, (b, color) -> b.method_10812(color.model()));
        });
    }

    public record Variant(class_2960 model, Map<String, Color> colors) {
    }

    public record Color(class_2960 model) {
    }
}

