/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.data.capture.MobColorData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityData;
import de.markusbordihn.easymobfarm.data.capture.MobEntityTypeData;
import de.markusbordihn.easymobfarm.data.capture.MobFoilData;
import de.markusbordihn.easymobfarm.data.capture.MobNameData;
import de.markusbordihn.easymobfarm.data.capture.MobRarityData;
import de.markusbordihn.easymobfarm.data.capture.MobVariantData;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public record MobCaptureData(String name, String type, class_1299<?> entityType, class_2487 data, class_1767 color, String variant, class_1814 rarity, boolean isFoil) {
    private static final int MAX_ID_LIMIT = 0x1000000;

    public MobCaptureData(String name, class_1299<?> entityType, class_1814 rarity) {
        this(name, MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), rarity, MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1299<?> entityType) {
        this(MobNameData.getName(entityType), MobEntityTypeData.getEntityTypeName(entityType), MobEntityTypeData.getEntityType(entityType), MobEntityData.getMobEntityData(entityType), MobColorData.getColor(entityType), MobVariantData.getVariant(entityType), MobRarityData.getRarity(entityType), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1309 livingEntity) {
        this(MobNameData.getName(livingEntity), MobEntityTypeData.getEntityTypeName(livingEntity), MobEntityTypeData.getEntityType(livingEntity), MobEntityData.getMobEntityData(livingEntity), MobColorData.getColor(livingEntity), MobVariantData.getVariant(livingEntity), MobRarityData.getRarity(livingEntity), MobFoilData.getRandomFoil());
    }

    public MobCaptureData(class_1799 itemStack, class_2487 compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(itemStack, compoundTag), MobEntityTypeData.getEntityType(itemStack, compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public MobCaptureData(class_2487 compoundTag) {
        this(MobNameData.getName(compoundTag), MobEntityTypeData.getEntityTypeName(compoundTag), MobEntityTypeData.getEntityType(compoundTag), MobEntityData.getMobEntityData(compoundTag), MobColorData.getColor(compoundTag), MobVariantData.getVariant(compoundTag), MobRarityData.getRarity(compoundTag), MobFoilData.getFoil(compoundTag));
    }

    public int getCardId() {
        int namespaceHash = 0;
        int pathHash = 0;
        if (this.type != null) {
            String[] parts = this.type.split(":");
            if (parts.length > 0) {
                namespaceHash = parts[0].hashCode();
            }
            if (parts.length > 1) {
                pathHash = parts[1].hashCode();
            }
        }
        int colorHash = this.color != null ? this.color.hashCode() : 0;
        int variantHash = this.variant != null ? this.variant.hashCode() : 0;
        int result = 17;
        result = 31 * result + namespaceHash;
        result = 31 * result + pathHash;
        result = 31 * result + colorHash;
        result = 31 * result + variantHash;
        result = 31 * result + (this.isFoil ? 1 : 0);
        result ^= result >>> 16;
        return (result & Integer.MAX_VALUE) % 0x1000000;
    }

    public MobCaptureData withColor(class_1767 color) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, color, this.variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withVariant(String variant) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, variant, this.rarity, this.isFoil);
    }

    public MobCaptureData withRarity(class_1814 rarity) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, rarity, this.isFoil);
    }

    public MobCaptureData withFoil(boolean isFoil) {
        return new MobCaptureData(this.name, this.type, this.entityType, this.data, this.color, this.variant, this.rarity, isFoil);
    }

    public MobCaptureData withData(class_2487 data) {
        return new MobCaptureData(this.name, this.type, this.entityType, data, this.color, this.variant, this.rarity, this.isFoil);
    }

    public boolean hasColor() {
        return this.color != null;
    }

    public boolean hasData() {
        return this.data != null && !this.data.method_33133();
    }

    public boolean hasVariant() {
        return this.variant != null && !this.variant.isEmpty();
    }

    public boolean hasRarity() {
        return this.rarity != null;
    }

    public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582("Name", this.name);
        compoundTag.method_10582("Type", class_2378.field_11145.method_10221(this.entityType).toString());
        compoundTag.method_10566("Data", (class_2520)this.data);
        if (this.hasColor()) {
            compoundTag.method_10582("Color", this.color.method_7792());
        }
        if (this.hasVariant()) {
            compoundTag.method_10582("Variant", this.variant);
        }
        compoundTag.method_10582("Rarity", this.rarity.name());
        compoundTag.method_10556("Foil", this.isFoil);
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }

    @Override
    public String toString() {
        return "MobCaptureData{, name='" + this.name + ", entityType=" + String.valueOf(this.entityType) + ", color=" + String.valueOf(this.color) + ", variant=" + this.variant + ", rarity=" + String.valueOf(this.rarity) + ", isFoil=" + this.isFoil + ", data=" + String.valueOf(this.data) + "}";
    }
}

