/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.entity.MobFarmBlockEntity;
import de.markusbordihn.easymobfarm.client.renderer.manager.EntityScalingManager;
import de.markusbordihn.easymobfarm.client.renderer.manager.RendererManager;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinition;
import de.markusbordihn.easymobfarm.data.capture.MobCaptureCardDefinitionManager;
import de.markusbordihn.easymobfarm.data.mobfarm.MobFarmType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionfc;

public class MobFarmBlockEntityRenderer<T extends MobFarmBlockEntity>
implements BlockEntityRenderer<T> {
    private static final Logger log = LogManager.getLogger((String)"Easy Mob Farm");

    public MobFarmBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Vec3 vec3) {
        if (!((MobFarmBlockEntity)((Object)blockEntity)).hasCapturedMob()) {
            RendererManager.removeEntity(blockEntity);
            return;
        }
        Entity entity = RendererManager.getOrCreateEntity(blockEntity);
        if (entity == null) {
            return;
        }
        try {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                this.renderLivingEntity(blockEntity, livingEntity, poseStack, buffer, combinedLight);
            } else if (entity instanceof Entity) {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
        }
        catch (Exception livingException) {
            try {
                this.renderGenericEntity(blockEntity, entity, poseStack, buffer, combinedLight);
            }
            catch (Exception genericException) {
                log.error("Failed to render entity {} for block entity {} with exception: {}", (Object)entity.getType(), (Object)blockEntity.getBlockPos(), (Object)genericException.getMessage());
            }
        }
    }

    private void renderLivingEntity(T blockEntity, LivingEntity entity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = dispatcher.getRenderer((Entity)entity);
        LivingEntityRenderState state = (LivingEntityRenderState)renderer.createRenderState((Entity)entity, 0.0f);
        entity.tickCount = (int)blockEntity.getLevel().getGameTime();
        MobCaptureCardDefinition mobCaptureCardDefinition = MobCaptureCardDefinitionManager.get(entity.getType());
        if (mobCaptureCardDefinition != null && mobCaptureCardDefinition.requiresAnimationTick() && entity.tickCount % 2 == 0) {
            entity.tick();
        }
        poseStack.pushPose();
        this.prepareEntityPose(blockEntity, (Entity)entity, poseStack);
        renderer.render((EntityRenderState)state, poseStack, buffer, combinedLight);
        poseStack.popPose();
    }

    private void renderGenericEntity(T blockEntity, Entity entity, PoseStack poseStack, MultiBufferSource buffer, int combinedLight) {
        EntityRenderDispatcher dispatcher = Minecraft.getInstance().getEntityRenderDispatcher();
        EntityRenderer renderer = dispatcher.getRenderer(entity);
        EntityRenderState stateRaw = renderer.createRenderState(entity, 0.0f);
        if (!(stateRaw instanceof EntityRenderState)) {
            return;
        }
        EntityRenderState state = stateRaw;
        entity.tickCount = (int)blockEntity.getLevel().getGameTime();
        poseStack.pushPose();
        this.prepareEntityPose(blockEntity, entity, poseStack);
        renderer.render(state, poseStack, buffer, combinedLight);
        poseStack.popPose();
    }

    private void prepareEntityPose(T blockEntity, Entity entity, PoseStack poseStack) {
        FlyingAnimal flyingAnimal;
        MobFarmType mobFarmType = ((MobFarmBlockEntity)((Object)blockEntity)).getFarmType();
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            poseStack.translate(0.5, 0.19, 0.5);
        } else {
            poseStack.translate(0.5, 0.08, 0.5);
        }
        float entityScaling = EntityScalingManager.getEntityScale(entity);
        if (mobFarmType == MobFarmType.LUCKY_DROP_FARM) {
            entityScaling *= 0.75f;
        }
        poseStack.scale(entityScaling, entityScaling, entityScaling);
        float rotationDegrees = switch ((Direction)blockEntity.getBlockState().getValue(MobFarmBlock.FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> -90.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(rotationDegrees));
        if (entity instanceof AbstractSchoolingFish) {
            poseStack.translate(-0.1, 0.5, 0.1);
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(2.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(15.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(-90.0f));
        } else if (entity instanceof Bee) {
            poseStack.translate(0.0, 0.5, 0.0);
        } else if (entity instanceof Squid) {
            poseStack.translate(0.0, 1.3, 0.0);
        } else if (entity instanceof Phantom) {
            poseStack.translate(0.0, 0.5, 0.0);
        } else if (entity instanceof FlyingAnimal && (flyingAnimal = (FlyingAnimal)entity).isFlying() || entity instanceof Guardian) {
            poseStack.translate(0.0, 0.3 / (double)entityScaling, 0.0);
        } else if (entity instanceof EnderDragon) {
            poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(0.0f));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(0.0f));
        }
    }
}

