/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.data.capture;

import de.markusbordihn.easymobfarm.config.MobCaptureCardRarityConfig;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Rarity;

public class MobRarityData {
    public static final String RARITY_TAG = "Rarity";

    private MobRarityData() {
    }

    public static Rarity getRarity(EntityType<?> entityType) {
        if (entityType == null) {
            return Rarity.COMMON;
        }
        if (MobCaptureCardRarityConfig.hasRarity(entityType)) {
            return MobCaptureCardRarityConfig.getRarity(entityType);
        }
        String entityName = entityType.getDescriptionId().toLowerCase(Locale.ROOT);
        if (entityName.contains("epic")) {
            return Rarity.EPIC;
        }
        if (entityName.contains("rare")) {
            return Rarity.RARE;
        }
        if (entityName.contains("uncommon")) {
            return Rarity.UNCOMMON;
        }
        return Rarity.COMMON;
    }

    public static Rarity getRarity(String rarity) {
        if (rarity == null || rarity.isEmpty()) {
            return Rarity.COMMON;
        }
        return Rarity.valueOf((String)rarity);
    }

    public static Rarity getRarity(LivingEntity livingEntity) {
        if (livingEntity == null) {
            return Rarity.COMMON;
        }
        return MobRarityData.getRarity(livingEntity.getType());
    }

    public static Rarity getRarity(CompoundTag compoundTag) {
        if (compoundTag == null || !compoundTag.contains(RARITY_TAG)) {
            return Rarity.COMMON;
        }
        return Rarity.valueOf((String)compoundTag.getString(RARITY_TAG));
    }
}

